/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xfile;

import com.sun.xfile.XFile;
import com.sun.xfile.XFileAccessor;
import java.io.IOException;
import java.io.OutputStream;

public class XFileOutputStream
extends OutputStream {
    private long fp;
    private XFileAccessor xfa;

    public XFileOutputStream(XFile xfile) throws IOException {
        this.xfa = xfile.newAccessor();
        if (this.xfa.open(xfile, true, false)) {
            if (!this.xfa.isFile()) {
                throw new IOException("not a file");
            }
            if (!this.xfa.canWrite()) {
                throw new IOException("no write permission");
            }
        }
        if (!this.xfa.mkfile()) {
            throw new IOException("no write permission");
        }
    }

    public XFileOutputStream(String name) throws IOException {
        this(new XFile(name));
    }

    public XFileOutputStream(XFile xfile, boolean append) throws IOException {
        this.xfa = xfile.newAccessor();
        boolean isExist = this.xfa.open(xfile, true, false);
        if (isExist) {
            if (!this.xfa.isFile()) {
                throw new IOException("not a file");
            }
            if (!this.xfa.canWrite()) {
                throw new IOException("no write permission");
            }
        }
        if (!(isExist && append || this.xfa.mkfile())) {
            throw new IOException("no write permission");
        }
        if (append) {
            this.fp = this.xfa.length();
        }
    }

    public XFileOutputStream(String name, boolean append) throws IOException {
        this(new XFile(name), append);
    }

    private synchronized void XFAwrite(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (len == 0) {
            return;
        }
        if (off < 0 || len < 0 || off >= b.length || off + len > b.length) {
            throw new IllegalArgumentException("Invalid argument");
        }
        this.xfa.write(b, off, len, this.fp);
        this.fp += (long)len;
    }

    @Override
    public void write(int b) throws IOException {
        this.XFAwrite(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.XFAwrite(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.XFAwrite(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.xfa.flush();
    }

    @Override
    public void close() throws IOException {
        this.xfa.close();
    }

    protected void finalize() throws IOException {
        this.close();
    }
}

