/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xfile;

import com.sun.xfile.XFileAccessor;
import com.sun.xfile.XFileExtensionAccessor;
import com.sun.xfile.XFilenameFilter;
import com.sun.xfile.XFurl;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class XFile {
    private XFileAccessor xfa;
    private XFurl url;
    private String urlStr;
    private File nativeFile;
    private boolean bound;
    static Hashtable cachedAccessors = new Hashtable();
    static Hashtable cachedExtensionAccessors = new Hashtable();

    public XFile(String name) {
        this.urlStr = name;
        if (name == null) {
            throw new NullPointerException();
        }
        try {
            this.url = new XFurl(name);
            this.xfa = this.loadAccessor(this.url);
        }
        catch (Exception e) {
            if (name.startsWith(".:")) {
                name = name.substring(2);
            }
            this.nativeFile = new File(name);
            this.xfa = this.makeNative(this.nativeFile);
        }
    }

    public XFile(XFile dir, String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        try {
            this.url = new XFurl(name);
            this.xfa = this.loadAccessor(this.url);
        }
        catch (Exception e) {
            if (name.startsWith(".:")) {
                name = name.substring(2);
                dir = null;
            }
            if (dir == null) {
                this.nativeFile = new File(name);
                this.xfa = this.makeNative(this.nativeFile);
            }
            if (dir.nativeFile != null) {
                this.nativeFile = new File(name).isAbsolute() ? new File(name) : new File(dir.nativeFile, name);
                this.xfa = this.makeNative(this.nativeFile);
            }
            try {
                this.url = new XFurl(dir.getURL(), name);
                this.xfa = this.loadAccessor(this.url);
            }
            catch (Exception ee) {
                System.out.println("Error: " + dir.getURL() + " " + name);
            }
        }
        this.urlStr = this.url.toString();
    }

    private Class loadClass(String proto, String suffix, Hashtable ht) throws ClassNotFoundException, IllegalAccessException {
        Class<?> cl = (Class<?>)ht.get(proto);
        if (cl != null) {
            return cl;
        }
        String prefixList = null;
        try {
            prefixList = System.getProperty("java.protocol.xfile");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        prefixList = prefixList == null ? "" : prefixList + "|";
        prefixList = prefixList + "com.sun";
        StringTokenizer pkgs = new StringTokenizer(prefixList, "|");
        while (cl == null && pkgs.hasMoreTokens()) {
            String prefix = pkgs.nextToken().trim();
            String clname = prefix + "." + proto + "." + suffix;
            try {
                cl = Class.forName(clname);
            }
            catch (Exception exception) {}
        }
        if (cl == null) {
            throw new ClassNotFoundException();
        }
        ht.put(proto, cl);
        return cl;
    }

    private XFileAccessor loadAccessor(XFurl url) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class cl = this.loadClass(url.getProtocol(), "XFileAccessor", cachedAccessors);
        if (cl == null) {
            return null;
        }
        return (XFileAccessor)cl.newInstance();
    }

    private XFileAccessor makeNative(File f) {
        char sep = File.separatorChar;
        try {
            this.url = new XFurl("file:///" + f.getPath().replace(sep, '/'));
            return this.loadAccessor(this.url);
        }
        catch (Exception e) {
            System.out.println("Error: makenative:" + f.getPath());
            return null;
        }
    }

    private boolean bind() {
        if (this.bound) {
            return true;
        }
        this.bound = this.xfa.open(this, false, false);
        return this.bound;
    }

    private boolean getBound() {
        return this.bound;
    }

    private File getNative() {
        return this.nativeFile;
    }

    protected XFileAccessor newAccessor() {
        try {
            return this.loadAccessor(this.url);
        }
        catch (Exception e) {
            return this.makeNative(this.nativeFile);
        }
    }

    private XFileAccessor getAccessor() {
        return this.xfa;
    }

    public XFileExtensionAccessor getExtensionAccessor() {
        try {
            String suffix = this.url.getProtocol().equals("nfs") ? "nfsXFileExtensionAccessor" : "XFileExtensionAccessor";
            Class cl = this.loadClass(this.url.getProtocol(), suffix, cachedExtensionAccessors);
            Constructor con = cl.getConstructor(this.getClass());
            return (XFileExtensionAccessor)con.newInstance(this);
        }
        catch (Exception e) {
            return null;
        }
    }

    private XFurl getURL() {
        return this.url;
    }

    public String getFileSystemName() {
        return this.url.getProtocol();
    }

    public String getName() {
        if (this.nativeFile != null) {
            return this.nativeFile.getName();
        }
        return this.url.getName();
    }

    public String getPath() {
        if (this.nativeFile != null) {
            return this.nativeFile.getPath();
        }
        return this.url.getPath();
    }

    public String getAbsolutePath() {
        if (this.nativeFile != null) {
            return this.nativeFile.getAbsolutePath();
        }
        return this.urlStr;
    }

    public String getCanonicalPath() throws IOException {
        if (this.nativeFile != null) {
            return this.nativeFile.getCanonicalPath();
        }
        return this.urlStr;
    }

    public String getParent() {
        if (this.nativeFile != null) {
            return this.nativeFile.getParent();
        }
        return this.url.getParent();
    }

    public boolean isAbsolute() {
        if (this.nativeFile != null) {
            return this.nativeFile.isAbsolute();
        }
        return true;
    }

    public boolean exists() {
        if (!this.bind()) {
            return false;
        }
        return this.xfa.exists();
    }

    public boolean canWrite() {
        if (!this.bind()) {
            return false;
        }
        return this.xfa.canWrite();
    }

    public boolean canRead() {
        if (!this.bind()) {
            return false;
        }
        return this.xfa.canRead();
    }

    public boolean isFile() {
        if (!this.bind()) {
            return false;
        }
        return this.xfa.isFile();
    }

    public boolean isDirectory() {
        if (!this.bind()) {
            return false;
        }
        return this.xfa.isDirectory();
    }

    public long lastModified() {
        if (!this.bind()) {
            return 0L;
        }
        return this.xfa.lastModified();
    }

    public long length() {
        if (!this.bind()) {
            return 0L;
        }
        return this.xfa.exists() ? this.xfa.length() : 0L;
    }

    public boolean renameTo(XFile dest) {
        if (dest == null) {
            throw new NullPointerException();
        }
        if (!this.xfa.getClass().isInstance(dest.getAccessor())) {
            return false;
        }
        if (!this.bind()) {
            return false;
        }
        boolean ok = this.xfa.renameTo(dest);
        if (ok) {
            this.url = dest.getURL();
            this.urlStr = dest.getAbsolutePath();
            this.nativeFile = dest.getNative();
            this.xfa = dest.getAccessor();
            this.bound = dest.getBound();
        }
        return ok;
    }

    public boolean mkdir() {
        this.bind();
        return this.xfa.mkdir();
    }

    public boolean mkdirs() {
        this.bind();
        if (this.exists()) {
            return false;
        }
        if (this.mkdir()) {
            return true;
        }
        String parent = this.getParent();
        return parent != null && new XFile(parent).mkdirs() && this.mkdir();
    }

    public String[] list() {
        if (!this.bind()) {
            return null;
        }
        return this.xfa.list();
    }

    public String[] list(XFilenameFilter filter) {
        if (!this.bind()) {
            return null;
        }
        String[] names = this.list();
        if (names == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < names.length; ++i) {
            if (filter != null && !filter.accept(this, names[i])) continue;
            v.addElement(names[i]);
        }
        Object[] files = new String[v.size()];
        v.copyInto(files);
        return files;
    }

    public boolean delete() {
        if (!this.bind()) {
            return false;
        }
        boolean ok = this.xfa.delete();
        this.bound = !ok;
        return ok;
    }

    public int hashCode() {
        return this.urlStr.hashCode() ^ 0x12D591;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof XFile)) {
            return false;
        }
        return this.url.toString().equals(((XFile)obj).getURL().toString());
    }

    public String toString() {
        if (this.nativeFile != null) {
            return this.nativeFile.toString();
        }
        return this.urlStr;
    }
}

