/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rpc;

import com.sun.rpc.Xdr;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.util.Hashtable;

public abstract class Connection
extends Thread {
    static Hashtable connections = new Hashtable();
    public String server;
    public int port;
    String proto;
    Hashtable waiters = new Hashtable();
    static final int IDLETIME = 300000;
    int xid;
    Xdr reply;
    int maxSize;
    Error err;
    private boolean running;

    public Connection(String server, int port, String proto, int maxSize) {
        this.server = server;
        this.port = port;
        this.proto = proto;
        this.maxSize = maxSize;
        this.setName("Listener-" + server);
        this.setDaemon(true);
    }

    public static Connection getCache(String server, int port, String proto) {
        Connection conn = (Connection)connections.get(server + ":" + port + ":" + proto);
        return conn;
    }

    public static void putCache(Connection conn) {
        connections.put(conn.server + ":" + conn.port + ":" + conn.proto, conn);
    }

    abstract void sendOne(Xdr var1) throws IOException;

    abstract void receiveOne(Xdr var1, int var2) throws IOException;

    abstract InetAddress getPeer();

    abstract void dropConnection();

    abstract void checkConnection();

    @Override
    public String toString() {
        return this.server + ":" + this.port + ":" + this.proto;
    }

    synchronized void suspendListener() {
        this.running = false;
        while (!this.running) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    synchronized void resumeListener() {
        this.running = true;
        this.notifyAll();
    }

    synchronized Xdr send(Xdr call, int timeout) throws IOException {
        this.checkConnection();
        this.resumeListener();
        this.sendOne(call);
        this.waiters.put(new Integer(call.xid), new Integer(timeout));
        while (this.xid != call.xid) {
            long t = System.currentTimeMillis();
            if (this.err != null) {
                throw this.err;
            }
            try {
                this.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.err != null) {
                throw this.err;
            }
            if ((timeout = (int)((long)timeout - (System.currentTimeMillis() - t))) > 0) continue;
            this.waiters.remove(new Integer(call.xid));
            throw new InterruptedIOException();
        }
        this.xid = 0;
        this.waiters.remove(new Integer(call.xid));
        this.notifyAll();
        return this.reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) {
                Connection connection = this;
                synchronized (connection) {
                    while (this.xid != 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                this.reply = new Xdr(this.maxSize);
                try {
                    this.receiveOne(this.reply, 300000);
                }
                catch (InterruptedIOException e) {
                    if (this.waiters.isEmpty()) {
                        this.dropConnection();
                    }
                    this.suspendListener();
                }
                catch (IOException e) {
                    continue;
                }
                Connection e = this;
                synchronized (e) {
                    this.xid = this.reply.xdr_int();
                    if (this.waiters.containsKey(new Integer(this.xid))) {
                        this.notifyAll();
                    } else {
                        this.xid = 0;
                    }
                }
            }
        }
        catch (Error e) {
            this.err = e;
            Connection connection = this;
            synchronized (connection) {
                this.notifyAll();
                throw e;
            }
        }
    }
}

