/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rpc;

import com.sun.rpc.Connection;
import com.sun.rpc.Xdr;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class ConnectSocket
extends Connection {
    static final int LAST_FRAG = Integer.MIN_VALUE;
    static final int SIZE_MASK = Integer.MAX_VALUE;
    static final int MTUSZ = 1456;
    private OutputStream outs;
    private InputStream ins;
    private Socket sock;
    Xdr rcv_mark = new Xdr(4);

    public ConnectSocket(String server, int port, int maxSize) throws IOException {
        super(server, port, "tcp", maxSize);
        this.doConnect();
        this.start();
    }

    private void doConnect() throws IOException {
        if (this.server == null) {
            throw new UnknownHostException("null host");
        }
        this.sock = new Socket(this.server, this.port);
        this.sock.setTcpNoDelay(true);
        this.ins = this.sock.getInputStream();
        this.outs = this.sock.getOutputStream();
    }

    private void doClose() throws IOException {
        if (this.ins != null) {
            this.ins.close();
            this.ins = null;
        }
        if (this.outs != null) {
            this.outs.close();
            this.outs = null;
        }
        if (this.sock != null) {
            this.sock.close();
            this.sock = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void sendOne(Xdr x) throws IOException {
        int lastbit = 0;
        int bufsiz = x.xdr_offset();
        ConnectSocket connectSocket = this;
        synchronized (connectSocket) {
            int recsize;
            for (int off = 4; off < bufsiz; off += recsize) {
                recsize = bufsiz - off;
                if (recsize > 1456) {
                    recsize = 1456;
                }
                if (off + recsize >= bufsiz) {
                    lastbit = Integer.MIN_VALUE;
                }
                x.xdr_offset(off - 4);
                int save = x.xdr_int();
                x.xdr_offset(off - 4);
                x.xdr_int(lastbit | recsize);
                this.outs.write(x.xdr_buf(), off - 4, recsize + 4);
                this.outs.flush();
                x.xdr_offset(off - 4);
                x.xdr_int(save);
            }
            x.xdr_offset(bufsiz);
        }
    }

    @Override
    void receiveOne(Xdr x, int timeout) throws IOException {
        boolean lastfrag = false;
        this.sock.setSoTimeout(timeout);
        try {
            int off = 0;
            while (!lastfrag) {
                if (this.ins.read(this.rcv_mark.xdr_buf()) != 4) {
                    throw new IOException("TCP record mark: lost connection");
                }
                this.rcv_mark.xdr_offset(0);
                long recsize = this.rcv_mark.xdr_u_int();
                lastfrag = (recsize & Integer.MIN_VALUE) != 0L;
                recsize &= Integer.MAX_VALUE;
                int i = 0;
                while ((long)i < recsize) {
                    int rcount = this.ins.read(x.xdr_buf(), off + i, (int)recsize - i);
                    if (rcount < 0) {
                        throw new IOException("TCP data: lost connection");
                    }
                    i += rcount;
                }
                off = (int)((long)off + recsize);
            }
            x.xdr_size(off);
        }
        catch (InterruptedIOException e) {
            throw e;
        }
        catch (IOException e) {
            this.reconnect();
            throw e;
        }
    }

    @Override
    InetAddress getPeer() {
        return this.sock.getInetAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void reconnect() {
        System.err.println("Lost connection to " + this.server + " - attempting to reconnect");
        ConnectSocket connectSocket = this;
        synchronized (connectSocket) {
            while (true) {
                try {
                    this.doClose();
                    this.doConnect();
                }
                catch (IOException e) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }
        System.err.println("Reconnected to " + this.server);
    }

    @Override
    void dropConnection() {
        try {
            this.doClose();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    void checkConnection() {
        if (this.sock != null) {
            return;
        }
        this.reconnect();
    }

    protected void finalize() throws Throwable {
        this.doClose();
        super.finalize();
    }
}

