/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rpc;

import com.sun.rpc.Connection;
import com.sun.rpc.Xdr;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class ConnectDatagram
extends Connection {
    DatagramSocket ds = new DatagramSocket();
    DatagramPacket dp;
    InetAddress addr;

    public ConnectDatagram(String server, int port, int maxSize) throws IOException {
        super(server, port, "udp", maxSize);
        this.addr = InetAddress.getByName(server);
        this.start();
    }

    @Override
    void sendOne(Xdr x) throws IOException {
        this.ds.send(new DatagramPacket(x.xdr_buf(), x.xdr_offset(), this.addr, this.port));
    }

    @Override
    void receiveOne(Xdr x, int timeout) throws IOException {
        this.ds.setSoTimeout(timeout);
        this.dp = new DatagramPacket(x.xdr_buf(), x.xdr_buf().length);
        this.ds.receive(this.dp);
    }

    @Override
    InetAddress getPeer() {
        return this.dp.getAddress();
    }

    @Override
    void dropConnection() {
    }

    @Override
    void checkConnection() {
    }

    protected void finalize() throws Throwable {
        if (this.ds != null) {
            this.ds.close();
            this.ds = null;
        }
        super.finalize();
    }
}

