/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nfs;

import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public final class NfsSecurity {
    static ResourceBundle props;
    static String secName;
    static String secMode;
    static String mech;
    static int service;
    static int qop;

    private static void initialize() {
        try {
            props = ResourceBundle.getBundle("com.sun.nfs.nfssec");
        }
        catch (MissingResourceException e) {
            props = null;
        }
    }

    private static void parseValue(String value) {
        StringTokenizer parser = new StringTokenizer(value, ":\n\r");
        secName = parser.nextToken();
        try {
            mech = parser.nextToken();
        }
        catch (NoSuchElementException e) {
            mech = null;
            service = 0;
            qop = 0;
            return;
        }
        String serviceString = parser.nextToken();
        service = serviceString.equals("none") ? 1 : (serviceString.equals("integrity") ? 2 : (serviceString.equals("privacy") ? 3 : 3));
        qop = Integer.parseInt(parser.nextToken());
    }

    public static boolean hasValue(String key) {
        if (props == null) {
            return false;
        }
        try {
            props.getString(key);
            return true;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    public static String getDefault() {
        if (props == null) {
            return "1";
        }
        try {
            return props.getString("default");
        }
        catch (MissingResourceException e) {
            return "1";
        }
    }

    public static String getPrefer() {
        if (props == null) {
            return null;
        }
        try {
            return props.getString("prefer");
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public static String getName(String key) {
        if (key.equals(secMode)) {
            return secName;
        }
        NfsSecurity.parseValue(props.getString(key));
        secMode = key;
        return secName;
    }

    public static String getMech(String key) {
        if (key.equals(secMode)) {
            return mech;
        }
        NfsSecurity.parseValue(props.getString(key));
        secMode = key;
        return mech;
    }

    public static int getService(String key) {
        if (key.equals(secMode)) {
            return service;
        }
        NfsSecurity.parseValue(props.getString(key));
        secMode = key;
        return service;
    }

    public static int getQop(String key) {
        if (key.equals(secMode)) {
            return qop;
        }
        NfsSecurity.parseValue(props.getString(key));
        secMode = key;
        return qop;
    }

    static {
        NfsSecurity.initialize();
    }
}

