/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nfs;

import java.io.IOException;

public class NfsException
extends IOException {
    int error;
    public static final int NFS_OK = 0;
    public static final int NFSERR_PERM = 1;
    public static final int NFSERR_NOENT = 2;
    public static final int NFSERR_IO = 5;
    public static final int NFSERR_NXIO = 6;
    public static final int NFSERR_ACCES = 13;
    public static final int NFSERR_EXIST = 17;
    public static final int NFSERR_XDEV = 18;
    public static final int NFSERR_NODEV = 19;
    public static final int NFSERR_NOTDIR = 20;
    public static final int NFSERR_ISDIR = 21;
    public static final int NFSERR_INVAL = 22;
    public static final int NFSERR_FBIG = 27;
    public static final int NFSERR_NOSPC = 28;
    public static final int NFSERR_ROFS = 30;
    public static final int NFSERR_MLINK = 31;
    public static final int NFSERR_NAMETOOLONG = 63;
    public static final int NFSERR_NOTEMPTY = 66;
    public static final int NFSERR_DQUOT = 69;
    public static final int NFSERR_STALE = 70;
    public static final int NFSERR_REMOTE = 71;
    public static final int NFSERR_BADHANDLE = 10001;
    public static final int NFSERR_NOT_SYNC = 10002;
    public static final int NFSERR_BAD_COOKIE = 10003;
    public static final int NFSERR_NOTSUPP = 10004;
    public static final int NFSERR_TOOSMALL = 10005;
    public static final int NFSERR_SERVERFAULT = 10006;
    public static final int NFSERR_BADTYPE = 10007;
    public static final int NFSERR_JUKEBOX = 10008;

    public NfsException(int error) {
        super("NFS error: " + error);
        this.error = error;
    }

    @Override
    public String toString() {
        switch (this.error) {
            case 0: {
                return "OK";
            }
            case 1: {
                return "Not owner";
            }
            case 2: {
                return "No such file or directory";
            }
            case 5: {
                return "I/O error";
            }
            case 6: {
                return "No such device or address";
            }
            case 13: {
                return "Permission denied";
            }
            case 17: {
                return "File exists";
            }
            case 18: {
                return "Attempted cross-device link";
            }
            case 19: {
                return "No such device";
            }
            case 20: {
                return "Not a directory";
            }
            case 21: {
                return "Is a directory";
            }
            case 22: {
                return "Invalid argument";
            }
            case 27: {
                return "File too large";
            }
            case 28: {
                return "No space left on device";
            }
            case 30: {
                return "Read-only file system";
            }
            case 31: {
                return "Too many links";
            }
            case 63: {
                return "File name too long";
            }
            case 66: {
                return "Directory not empty";
            }
            case 69: {
                return "Disk quota exceeded";
            }
            case 70: {
                return "Stale NFS file handle";
            }
            case 71: {
                return "Too many levels of remote in path";
            }
            case 10001: {
                return "Illegal NFS file handle";
            }
            case 10002: {
                return "Update sync mismatch";
            }
            case 10003: {
                return "Readdir cookie is stale";
            }
            case 10004: {
                return "Operation not supported";
            }
            case 10005: {
                return "Buffer/request too small";
            }
            case 10006: {
                return "Server fault";
            }
            case 10007: {
                return "Bad type";
            }
            case 10008: {
                return "Jukebox error: try later";
            }
        }
        return "Unknown NFS error: " + this.error;
    }
}

