/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nfs;

import com.sun.nfs.Mount;
import com.sun.nfs.Nfs;
import com.sun.nfs.Nfs2;
import com.sun.nfs.Nfs3;
import com.sun.nfs.NfsException;
import com.sun.nfs.NfsSecurity;
import com.sun.nfs.NfsURL;
import com.sun.rpc.ConnectDatagram;
import com.sun.rpc.ConnectSocket;
import com.sun.rpc.Connection;
import com.sun.rpc.CredGss;
import com.sun.rpc.CredUnix;
import com.sun.rpc.MsgAcceptedException;
import com.sun.rpc.Rpc;
import com.sun.rpc.RpcHandler;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Hashtable;

public class NfsConnect {
    private static byte[] pubfh2 = new byte[32];
    private static byte[] pubfh3 = new byte[0];
    private static Hashtable cacheNfsConnect = new Hashtable();
    static final int NFS_PORT = 2049;
    static final int NFS_PROG = 100003;
    static final int MAXBUF = 33280;
    String server;
    int port;
    int version;
    String proto;
    boolean pub;
    static CredUnix cred = new CredUnix();
    static RpcHandler rhandler;
    static String sec_flavor;

    NfsConnect(String server, int port, int version, String proto, boolean pub) {
        this.server = server;
        this.port = port;
        this.version = version;
        this.proto = proto;
        this.pub = pub;
    }

    static Nfs connect(String urlstr) throws IOException {
        NfsURL url = new NfsURL(urlstr);
        String server = url.getHost();
        int port = url.getPort();
        String path = url.getFile();
        int version = url.getVersion();
        String proto = url.getProto();
        boolean pub = url.getPub();
        NfsConnect n = null;
        if (server == null) {
            throw new UnknownHostException();
        }
        if (version == 0 && proto == null && pub) {
            n = NfsConnect.cache_get(server);
        }
        if (n == null) {
            return NfsConnect.connect(server, path, port, version, proto, pub);
        }
        return NfsConnect.connect(server, path, n.port, n.version, n.proto, n.pub);
    }

    static Nfs connect(String server, int port, String path) throws IOException {
        NfsConnect n = NfsConnect.cache_get(server);
        if (n == null) {
            return NfsConnect.connect(server, path, port, 0, null, true);
        }
        return NfsConnect.connect(server, path, n.port, n.version, n.proto, n.pub);
    }

    static Nfs connect(String server, String path, int port, int vers, String proto, boolean pub) throws IOException {
        Connection conn;
        Nfs nfs;
        if (port == 0) {
            port = 2049;
        }
        if (path == null || path.length() == 0) {
            path = ".";
        }
        if ((nfs = Nfs.cache_get(server, path)) != null) {
            nfs.getattr();
            if (nfs.isSymlink()) {
                return NfsConnect.followLink(nfs);
            }
            return nfs;
        }
        if (proto == null) {
            conn = Connection.getCache(server, port, "tcp");
            if (conn == null) {
                conn = Connection.getCache(server, port, "udp");
            }
            if (conn == null) {
                try {
                    conn = new ConnectSocket(server, port, 33280);
                    Connection.putCache(conn);
                    proto = "tcp";
                }
                catch (UnknownHostException e) {
                    throw e;
                }
                catch (IOException e) {
                    conn = new ConnectDatagram(server, port, 33280);
                    Connection.putCache(conn);
                    proto = "udp";
                }
            }
        } else if (proto.equals("tcp")) {
            conn = Connection.getCache(server, port, "tcp");
            if (conn == null) {
                conn = new ConnectSocket(server, port, 33280);
                Connection.putCache(conn);
            }
        } else if (proto.equals("udp")) {
            conn = Connection.getCache(server, port, "udp");
            if (conn == null) {
                conn = new ConnectDatagram(server, port, 33280);
                Connection.putCache(conn);
            }
        } else {
            throw new IOException("Unknown protocol: " + proto);
        }
        if (pub) {
            block35: {
                try {
                    switch (vers) {
                        case 0: {
                            try {
                                nfs = NfsConnect.tryNfs(conn, pubfh3, path, 3, false);
                                vers = 3;
                            }
                            catch (MsgAcceptedException e) {
                                if (e.error != 2) {
                                    throw e;
                                }
                                vers = 2;
                                nfs = NfsConnect.tryNfs(conn, pubfh2, path, 2, false);
                            }
                            break;
                        }
                        case 2: {
                            nfs = NfsConnect.tryNfs(conn, pubfh2, path, 2, false);
                            break;
                        }
                        case 3: {
                            nfs = NfsConnect.tryNfs(conn, pubfh3, path, 3, false);
                        }
                    }
                }
                catch (MsgAcceptedException e) {
                    if (e.error != 4) {
                        throw e;
                    }
                    if (vers == 0) {
                        vers = 3;
                    }
                }
                catch (NfsException e) {
                    if (e.error != 70) {
                        if (e.error != 10001) {
                            throw e;
                        }
                    }
                    if (vers != 0) break block35;
                    vers = 3;
                }
            }
            if (nfs != null) {
                NfsConnect.cache_put(new NfsConnect(server, port, vers, proto, true));
                return nfs;
            }
        }
        if (path.equals(".")) {
            path = "/";
        }
        Mount m = new Mount();
        byte[] fh = m.getFH(server, path, vers);
        sec_flavor = m.getSec();
        NfsConnect.cache_put(new NfsConnect(server, port, vers, proto, false));
        return NfsConnect.tryNfs(conn, fh, path, vers, true);
    }

    private static Nfs tryNfs(Connection conn, byte[] pubfh, String path, int vers, boolean mount) throws IOException {
        Rpc rpc = new Rpc(conn, 100003, vers);
        String defaultSec = NfsSecurity.getDefault();
        if (defaultSec.equals("1")) {
            rpc.setCred(cred);
        } else if (NfsSecurity.getMech(defaultSec) != null) {
            rpc.setCred(new CredGss("nfs", NfsSecurity.getMech(defaultSec), NfsSecurity.getService(defaultSec), NfsSecurity.getQop(defaultSec)));
        } else {
            rpc.setCred(cred);
        }
        rpc.setRpcHandler(rhandler);
        Nfs pubnfs = vers == 2 ? new Nfs2(rpc, pubfh, path, null) : new Nfs3(rpc, pubfh, path, null);
        if (path.equals("/.")) {
            return pubnfs;
        }
        if (mount) {
            if (NfsSecurity.getMech(sec_flavor) != null) {
                rpc.setCred(new CredGss("nfs", NfsSecurity.getMech(sec_flavor), NfsSecurity.getService(sec_flavor), NfsSecurity.getQop(sec_flavor)));
            }
            pubnfs.getattr();
            Nfs.cache_put(pubnfs);
            return pubnfs;
        }
        return pubnfs.lookup(null);
    }

    static Nfs followLink(Nfs link) throws IOException {
        String newpath;
        String base = link.name;
        String text = link.readlink();
        String server = link.rpc.conn.server;
        int port = link.rpc.conn.port;
        if (text.startsWith("nfs://")) {
            NfsURL url = new NfsURL(text);
            server = url.getHost();
            port = url.getPort();
            newpath = url.getFile();
        } else if (text.startsWith("/")) {
            newpath = text;
        } else {
            int head = 0;
            int tail = base.lastIndexOf(47);
            int len = text.length();
            while ((text.regionMatches(head, "..", 0, len - head) || text.startsWith("../", head)) && (head += 3) < len) {
                tail = base.lastIndexOf(47, tail - 1);
            }
            if (head > len) {
                head = len;
            }
            tail = tail < 0 ? 0 : ++tail;
            newpath = base.substring(0, tail) + text.substring(head);
        }
        try {
            return NfsConnect.connect(server, port, newpath);
        }
        catch (IOException e) {
            System.err.println(e + ": symbolic link: " + base + " -> " + text);
            return link;
        }
    }

    private static void cache_put(NfsConnect n) {
        cacheNfsConnect.put(n.server, n);
    }

    private static NfsConnect cache_get(String server) {
        return (NfsConnect)cacheNfsConnect.get(server);
    }

    public static CredUnix getCred() {
        return cred;
    }

    public static void setRpcHandler(RpcHandler r) {
        rhandler = r;
    }
}

