/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nfs;

import com.sun.nfs.NfsSecurity;
import com.sun.rpc.CredUnix;
import com.sun.rpc.Rpc;
import com.sun.rpc.Xdr;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;

class Mount {
    private static final int MOUNTPROG = 100005;
    private static final int MOUNTPROC_MNT = 1;
    private static final int MOUNTPROC_UMNT = 3;
    private static final int MOUNTPROC_EXPORT = 5;
    private static final int FHSIZE = 32;
    private static final int FHSIZE3 = 64;
    private static final int ENOENT = 2;
    private static final int EACCES = 13;
    String sec_flavor;

    Mount() {
    }

    byte[] getFH(String server, String path, int vers) throws UnknownHostException, IOException {
        Xdr callmsg = new Xdr(1024);
        Rpc mnt = new Rpc(server, 0, 100005, vers == 2 ? 1 : 3, "udp", 512);
        mnt.setCred(new CredUnix(0, 0));
        mnt.rpc_header(callmsg, 1);
        callmsg.xdr_string(path);
        Xdr replymsg = mnt.rpc_call(callmsg, 3000, 3);
        int status = replymsg.xdr_int();
        if (status != 0) {
            if (!(status != 2 && status != 13 || path.startsWith("/"))) {
                return this.getFH(server, "/" + path, vers);
            }
            throw new IOException("Mount status: " + status);
        }
        byte[] fh = vers == 2 ? replymsg.xdr_raw(32) : replymsg.xdr_bytes();
        this.sec_flavor = null;
        if (vers == 3) {
            int numsec = replymsg.xdr_int();
            String prefer = NfsSecurity.getPrefer();
            while (numsec-- > 0) {
                String secmode = Integer.toString(replymsg.xdr_int());
                if (prefer != null && prefer.equals(secmode)) {
                    this.sec_flavor = prefer;
                }
                if (this.sec_flavor != null || !NfsSecurity.hasValue(secmode)) continue;
                this.sec_flavor = secmode;
            }
        }
        if (this.sec_flavor == null) {
            this.sec_flavor = NfsSecurity.getDefault();
        }
        mnt.rpc_header(callmsg, 3);
        callmsg.xdr_string(path);
        try {
            mnt.rpc_call(callmsg, 1000, 1);
        }
        catch (InterruptedIOException interruptedIOException) {
            // empty catch block
        }
        return fh;
    }

    String getSec() {
        return this.sec_flavor;
    }

    static String[] getExports(String server) throws UnknownHostException, IOException {
        String[] tmp;
        Xdr replymsg;
        Xdr callmsg = new Xdr(255);
        String[] elist = new String[32];
        int i = 0;
        try {
            Rpc mnt = new Rpc(server, 0, 100005, 1, "tcp", 8192);
            mnt.setCred(new CredUnix(0, 0));
            mnt.rpc_header(callmsg, 5);
            replymsg = mnt.rpc_call(callmsg, 3000, 3);
        }
        catch (UnknownHostException e) {
            throw e;
        }
        catch (IOException e) {
            return new String[0];
        }
        while (replymsg.xdr_bool()) {
            elist[i++] = replymsg.xdr_string();
            if (i >= elist.length) {
                tmp = elist;
                elist = new String[i * 2];
                System.arraycopy(tmp, 0, elist, 0, i);
            }
            while (replymsg.xdr_bool()) {
                replymsg.xdr_string();
            }
        }
        if (i < elist.length) {
            tmp = elist;
            elist = new String[i];
            System.arraycopy(tmp, 0, elist, 0, i);
        }
        return elist;
    }
}

