/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nfs;

import com.sun.nfs.Nfs;
import java.io.IOException;

public class Buffer
extends Thread {
    Nfs nfs;
    long foffset;
    byte[] buf;
    int bufoff;
    int buflen;
    int bufsize;
    int minOffset;
    int maxOffset;
    int status;
    private int action;
    boolean eof;
    IOException e;
    Error err;
    long writeVerifier;
    int syncType;
    private static final int IDLE = 0;
    private static final int LOAD = 1;
    private static final int UNLOAD = 2;
    private static final int EXIT = 3;
    static final int EMPTY = 0;
    static final int LOADED = 1;
    static final int DIRTY = 2;
    static final int COMMIT = 3;

    public Buffer(Nfs nfs, int foffset, int bufsize) {
        this.nfs = nfs;
        this.foffset = foffset;
        this.bufsize = bufsize;
        this.buflen = 0;
        this.minOffset = bufsize;
        this.maxOffset = 0;
        this.setDaemon(true);
        try {
            this.setName("Buffer-" + foffset / bufsize);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.action = 0;
        this.start();
    }

    synchronized int copyFrom(byte[] buff, int boff, long foffset, int length) throws IOException {
        if (this.e != null) {
            throw this.e;
        }
        if (this.err != null) {
            throw this.err;
        }
        if (this.status == 0) {
            throw new IOException("no data");
        }
        if (this.buflen < this.bufsize) {
            byte[] nbuf = new byte[this.bufsize];
            if (this.buflen > 0) {
                System.arraycopy(this.buf, this.bufoff, nbuf, 0, this.buflen);
            }
            this.buflen = this.bufsize;
            this.bufoff = 0;
            this.buf = nbuf;
        }
        int off = (int)(foffset - this.foffset);
        int copylen = Math.min(length, this.buflen - off);
        copylen = Math.min(copylen, (int)(this.nfs.length() - foffset));
        System.arraycopy(this.buf, this.bufoff + off, buff, boff, copylen);
        return copylen;
    }

    synchronized int copyTo(byte[] buff, int boff, long foffset, int length) throws IOException {
        if (this.e != null) {
            throw this.e;
        }
        if (this.err != null) {
            throw this.err;
        }
        int off = (int)(foffset - this.foffset);
        int copylen = Math.min(length, this.bufsize - off);
        if (this.status == 0) {
            long bufEnd = Math.min(this.nfs.length(), this.foffset + (long)this.nfs.wsize);
            if (this.foffset < this.nfs.length() && (foffset > this.foffset || foffset + (long)length < bufEnd)) {
                this.startLoad();
                this.waitLoaded();
            }
        }
        if (off + copylen > this.buflen) {
            byte[] nbuf = new byte[this.bufsize];
            if (this.buf != null) {
                System.arraycopy(this.buf, this.bufoff, nbuf, 0, this.buflen);
            }
            this.buf = nbuf;
            this.bufoff = 0;
            this.buflen = this.bufsize;
        }
        System.arraycopy(buff, boff, this.buf, this.bufoff + off, copylen);
        this.status = 2;
        if (off < this.minOffset) {
            this.minOffset = off;
        }
        if (off + copylen > this.maxOffset) {
            this.maxOffset = off + copylen;
        }
        return copylen;
    }

    synchronized void startLoad() {
        this.action = 1;
        this.notifyAll();
    }

    synchronized void waitLoaded() throws IOException {
        if (this.e != null) {
            throw this.e;
        }
        if (this.err != null) {
            throw this.err;
        }
        while (this.status == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.e != null) {
                throw this.e;
            }
            if (this.err == null) continue;
            throw this.err;
        }
    }

    synchronized void waitUnloaded() throws IOException {
        if (this.e != null) {
            throw this.e;
        }
        if (this.err != null) {
            throw this.err;
        }
        while (this.action == 2) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.e != null) {
                throw this.e;
            }
            if (this.err == null) continue;
            throw this.err;
        }
    }

    synchronized void startUnload(int sync) {
        this.nfs.beginWrite();
        this.action = 2;
        this.syncType = sync;
        this.notifyAll();
    }

    synchronized void exit() {
        this.action = 3;
        this.notifyAll();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        var1_1 = this;
        synchronized (var1_1) {
            try {
                while (true) {
                    if (this.action == 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException var2_2) {}
                        continue;
                    }
                    switch (this.action) {
                        case 1: {
                            try {
                                this.nfs.read_otw(this);
                            }
                            catch (IOException e) {
                                if (this.e != null) ** GOTO lbl20
                                this.e = e;
                            }
lbl20:
                            // 3 sources

                            this.status = 1;
                            break;
                        }
                        case 2: {
                            try {
                                saveMin = this.minOffset;
                                while (this.minOffset < this.maxOffset) {
                                    this.minOffset += this.nfs.write_otw(this);
                                }
                                this.minOffset = this.bufsize;
                                this.maxOffset = 0;
                            }
                            catch (IOException e) {
                                if (this.e != null) ** GOTO lbl34
                                this.e = e;
                            }
lbl34:
                            // 3 sources

                            this.nfs.endWrite();
                            break;
                        }
                        case 3: {
                            this.notifyAll();
                            this.buf = null;
                            return;
                        }
                    }
                    this.action = 0;
                    this.notifyAll();
                }
            }
            catch (Error e) {
                this.err = e;
                this.notifyAll();
                throw e;
            }
        }
    }

    @Override
    public String toString() {
        return this.nfs.name + " @ " + this.foffset + " for " + this.buflen;
    }
}

