/*
 * Decompiled with CFR 0.152.
 */
package com.sun.http;

import com.sun.xfile.XFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;

public class XFileAccessor
implements com.sun.xfile.XFileAccessor {
    XFile xf;
    URL url;
    URLConnection urlConn;
    InputStream iStream;
    OutputStream oStream;
    long fp;

    @Override
    public boolean open(XFile xf, boolean serial, boolean readOnly) {
        if (!serial) {
            return false;
        }
        this.xf = xf;
        try {
            this.url = new URL(xf.toString());
            this.urlConn = this.url.openConnection();
            this.urlConn.setDoInput(readOnly);
            this.urlConn.setDoOutput(!readOnly);
            this.urlConn.connect();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public XFile getXFile() {
        return this.xf;
    }

    @Override
    public boolean exists() {
        try {
            if (this.iStream == null) {
                this.iStream = this.urlConn.getInputStream();
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean canWrite() {
        try {
            if (this.oStream == null) {
                this.oStream = this.urlConn.getOutputStream();
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean canRead() {
        return this.exists();
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public long lastModified() {
        return this.urlConn.getLastModified();
    }

    @Override
    public long length() {
        long len = this.urlConn.getContentLength();
        return len < 0L ? 0L : len;
    }

    @Override
    public boolean mkfile() {
        try {
            if (this.oStream == null) {
                this.oStream = this.urlConn.getOutputStream();
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean mkdir() {
        return false;
    }

    @Override
    public boolean renameTo(XFile dest) {
        return false;
    }

    @Override
    public String[] list() {
        return new String[0];
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public int read(byte[] b, int off, int len, long foff) throws IOException {
        int c;
        if (this.iStream == null) {
            this.iStream = this.urlConn.getInputStream();
        }
        if (foff > this.fp) {
            this.iStream.skip(foff - this.fp);
            this.fp = foff;
        }
        if ((c = this.iStream.read(b, off, len)) > 0) {
            this.fp += (long)c;
        }
        return c;
    }

    @Override
    public void write(byte[] b, int off, int len, long foff) throws IOException {
        if (this.oStream == null) {
            this.oStream = this.urlConn.getOutputStream();
        }
        this.oStream.write(b, off, len);
        this.fp += (long)len;
    }

    @Override
    public void flush() throws IOException {
        if (this.oStream != null) {
            this.oStream.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.iStream != null) {
            this.iStream.close();
            this.iStream = null;
        }
        if (this.oStream != null) {
            this.oStream.close();
            this.oStream = null;
        }
    }

    public String toString() {
        return this.url.toString();
    }
}

