/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gssapi.samples;

import com.sun.gssapi.GSSContext;
import com.sun.gssapi.GSSException;
import com.sun.gssapi.GSSManager;
import com.sun.gssapi.GSSName;
import com.sun.gssapi.MessageProp;
import com.sun.gssapi.Oid;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StringBufferInputStream;
import java.net.Socket;

class GSSClient {
    private static Socket s;

    GSSClient() {
    }

    public static void main(String[] args) {
        int port = 4444;
        if (args.length < 3) {
            GSSClient.usage();
            GSSClient.exit(1);
        }
        String serverHost = args[args.length - 3];
        String serverName = args[args.length - 2];
        String message = args[args.length - 1];
        try {
            Oid mechOid = GSSManager.getDefaultMech();
            for (int i = 0; i < args.length - 3; ++i) {
                if (args[i].equals("-port")) {
                    if (i >= args.length - 4) {
                        GSSClient.usage();
                        GSSClient.exit(-1);
                    }
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                if (!args[i].equals("-mech")) continue;
                if (i >= args.length - 4) {
                    GSSClient.usage();
                    GSSClient.exit(-1);
                }
                mechOid = new Oid(args[++i]);
            }
            s = new Socket(serverHost, port);
            GSSContext aCtxt = GSSClient.createCtxt(serverName, mechOid);
            GSSClient.print("\nContext established\n");
            GSSClient.displayContext(aCtxt);
            GSSClient.sendMsgToPeer(aCtxt, message);
            GSSClient.verifyMsgFromPeer(aCtxt, message);
            aCtxt.dispose();
            GSSClient.exit(0);
        }
        catch (IOException e) {
            GSSClient.print("\n**Communication ERROR**:\t" + e.getMessage());
            e.printStackTrace();
            GSSClient.exit(-1);
        }
        catch (GSSException e) {
            GSSClient.print("\n**GSSAPI ERROR**:\t" + e.getMessage());
            e.printStackTrace();
            GSSClient.exit(-1);
        }
    }

    private static GSSContext createCtxt(String serverName, Oid mechOid) throws GSSException, IOException {
        GSSContext aCtxt = new GSSContext(new GSSName(serverName, GSSName.NT_HOSTBASED_SERVICE), mechOid, null, 0);
        aCtxt.requestConf(true);
        aCtxt.requestInteg(true);
        aCtxt.requestMutualAuth(true);
        aCtxt.requestReplayDet(true);
        aCtxt.requestSequenceDet(true);
        DataInputStream dis = new DataInputStream(s.getInputStream());
        DataOutputStream dos = new DataOutputStream(s.getOutputStream());
        byte[] inTok = new byte[]{};
        GSSClient.print("\nCalling init.....");
        while (true) {
            byte[] outTok;
            if ((outTok = aCtxt.init(inTok, 0, inTok.length)) != null) {
                GSSClient.print("\tSending token to peer (" + outTok.length + " bytes)...");
                dos.writeInt(outTok.length);
                dos.write(outTok, 0, outTok.length);
            }
            if (aCtxt.isEstablished()) break;
            inTok = new byte[dis.readInt()];
            GSSClient.print("\tReceiving token from peer (" + inTok.length + " bytes)...");
            dis.readFully(inTok, 0, inTok.length);
        }
        return aCtxt;
    }

    private static void displayContext(GSSContext aCtxt) throws GSSException {
        GSSClient.print("Context Information....");
        if (aCtxt.getLifetime() == Integer.MAX_VALUE) {
            GSSClient.print("\tOver mech:\t" + aCtxt.getMech().toString() + " for  " + " INDEFINITE seconds");
        } else {
            GSSClient.print("\tOver mech:\t" + aCtxt.getMech().toString() + " for  " + aCtxt.getLifetime() + " seconds");
        }
        GSSClient.print("\tInitiator:\t" + aCtxt.getSrcName().toString());
        GSSClient.print("\tAcceptor:\t" + aCtxt.getTargName().toString());
        if (aCtxt.getDelegCredState()) {
            GSSClient.print("\tDelegated credentials available.");
        } else {
            GSSClient.print("\tNO delegated credentials");
        }
        if (aCtxt.getMutualAuthState()) {
            GSSClient.print("\tMutaul Authentication ON");
        } else {
            GSSClient.print("\tNO mutual authentication performed.");
        }
        if (aCtxt.getReplayDetState()) {
            GSSClient.print("\tReplay detection ON");
        } else {
            GSSClient.print("NO replay detection");
        }
        if (aCtxt.getSequenceDetState()) {
            GSSClient.print("\tSequence detection ON");
        } else {
            GSSClient.print("\tNO sequence detection");
        }
        if (aCtxt.getAnonymityState()) {
            GSSClient.print("\tAnonymous context");
        }
        if (aCtxt.isTransferable()) {
            GSSClient.print("\tContext is transferable");
        } else {
            GSSClient.print("\tNO context transfer");
        }
        if (aCtxt.isProtReady()) {
            GSSClient.print("\tContext protection is ready");
        } else {
            GSSClient.print("**ERROR wrong state - context established, but isProtReady = false");
        }
        if (aCtxt.getConfState()) {
            GSSClient.print("\tConfidentiality available");
        } else {
            GSSClient.print("\tNO confidentiality services");
        }
        if (aCtxt.getIntegState()) {
            GSSClient.print("\tIntegrity available");
        } else {
            GSSClient.print("\tNO integrity services");
        }
    }

    private static void sendMsgToPeer(GSSContext aCtxt, String msg) throws GSSException, IOException {
        GSSClient.print("\nWrapping message for server...");
        MessageProp mInfo = new MessageProp(0, true);
        byte[] tok = aCtxt.wrap(msg.getBytes(), 0, msg.length(), mInfo);
        DataOutputStream dos = new DataOutputStream(s.getOutputStream());
        dos.writeInt(tok.length);
        dos.write(tok);
        dos.flush();
    }

    private static void verifyMsgFromPeer(GSSContext aCtxt, String msg) throws GSSException, IOException {
        GSSClient.print("receiving MIC message from server...");
        DataInputStream dis = new DataInputStream(s.getInputStream());
        int len = dis.readInt();
        GSSClient.print("Receiving message from peer (" + len + " bytes)");
        MessageProp mInfo = new MessageProp();
        aCtxt.verifyMIC(dis, new StringBufferInputStream(msg), mInfo);
        GSSClient.print("Verified server message protected with QOP = " + mInfo.getQOP());
    }

    private static void usage() {
        GSSClient.print("GSSClient [-port port] [-mech 1.2.3.3] serverhost servername message");
    }

    private static void print(String msg) {
        System.out.println(msg);
    }

    private static void exit(int status) {
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        System.exit(status);
    }
}

