/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gssapi;

import com.sun.gssapi.C018FE95;
import com.sun.gssapi.GSSCredSpi;
import com.sun.gssapi.GSSException;
import com.sun.gssapi.GSSNameSpi;
import com.sun.gssapi.Oid;
import java.security.Provider;
import java.util.Properties;
import java.util.StringTokenizer;

class MechInfo {
    private Oid m_oid;
    private Oid[] m_names;
    private String _V2395ABD;
    private String _V108CA91;
    private String _V901D6C2;
    private Provider _V510CA83;
    private Class _V80013BE;
    private Class _V29ED8BF;
    private Class _V30FDA16;
    private static Properties M_oidAlias = new Properties();

    private MechInfo() {
    }

    MechInfo(Provider p, String oid) throws GSSException {
        this.m_oid = new Oid(oid);
        this._V510CA83 = p;
        MechInfo.updateOidAlias(p, oid);
        String aStr = MechInfo._M73F1AC8(p, oid, "_K872D1AC");
        if (aStr != null) {
            StringTokenizer st = new StringTokenizer(aStr, ":");
            this.m_names = new Oid[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                this.m_names[i] = new Oid(st.nextToken());
                ++i;
            }
        } else {
            throw new GSSException(2);
        }
        this._V2395ABD = MechInfo._M73F1AC8(p, oid, "_K532D1BD");
        this._V108CA91 = MechInfo._M73F1AC8(p, oid, "_K1000A49");
        this._V901D6C2 = MechInfo._M73F1AC8(p, oid, "_K2102CC5");
        if (this._V2395ABD == null || this._V108CA91 == null || this._V901D6C2 == null) {
            throw new GSSException(2);
        }
    }

    boolean supportsName(Oid nameOid) {
        for (int i = 0; i < this.m_names.length; ++i) {
            if (!this.m_names[i].equals(nameOid)) continue;
            return true;
        }
        return false;
    }

    Oid[] getNames() {
        return this.m_names;
    }

    Oid getOid() {
        return this.m_oid;
    }

    GSSCredSpi getCredInstance() throws GSSException {
        try {
            if (this._V29ED8BF == null) {
                this._V29ED8BF = Class.forName(this._V901D6C2);
            }
            return (GSSCredSpi)this._V29ED8BF.newInstance();
        }
        catch (Exception e) {
            throw new GSSException(16);
        }
    }

    C018FE95 _M4092FBA() throws GSSException {
        try {
            if (this._V30FDA16 == null) {
                this._V30FDA16 = Class.forName(this._V108CA91);
            }
            return (C018FE95)this._V30FDA16.newInstance();
        }
        catch (Exception e) {
            throw new GSSException(16);
        }
    }

    GSSNameSpi getNameInstance() throws GSSException {
        try {
            if (this._V80013BE == null) {
                this._V29ED8BF = Class.forName(this._V2395ABD);
            }
            return (GSSNameSpi)this._V29ED8BF.newInstance();
        }
        catch (Exception e) {
            throw new GSSException(16);
        }
    }

    Provider getProvider() {
        return this._V510CA83;
    }

    private static String _M73F1AC8(Provider p, String _V0095DCA, String key) {
        String aStr = p.getProperty("JGSS.Mech." + _V0095DCA + "." + key);
        if (aStr != null) {
            return aStr;
        }
        aStr = MechInfo.oidStrToAlias(_V0095DCA);
        if (aStr == null) {
            return null;
        }
        return p.getProperty("JGSS.Mech." + aStr + "." + key);
    }

    private static String oidStrToAlias(String _V0095DCA) {
        return M_oidAlias.getProperty(_V0095DCA);
    }

    private static String aliasToOidStr(String mechAlias) {
        return M_oidAlias.getProperty(mechAlias);
    }

    private static synchronized void updateOidAlias(Provider p, String _V0095DCA) {
        if (M_oidAlias.getProperty(_V0095DCA) != null) {
            return;
        }
        String aStr = p.getProperty("JGSS.Mech." + _V0095DCA + ".Alias");
        if (aStr != null) {
            M_oidAlias.put(_V0095DCA, aStr);
            M_oidAlias.put(aStr, _V0095DCA);
        }
    }

    static boolean implementsMech(Provider p, String oid) {
        String[] mechs = MechInfo.getMechsForProvider(p);
        if (mechs == null) {
            return false;
        }
        for (int i = 0; i < mechs.length; ++i) {
            if (!mechs[i].equals(oid)) continue;
            return true;
        }
        return false;
    }

    static MechInfo[] getInfoForAllMechs(Provider p) {
        String mechsStr = p.getProperty("JGSS.Mechs");
        if (mechsStr == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(mechsStr, ":");
        MechInfo[] mInfo = new MechInfo[st.countTokens()];
        for (int i = 0; i < mInfo.length; ++i) {
            try {
                mInfo[i] = new MechInfo(p, st.nextToken());
                continue;
            }
            catch (GSSException gSSException) {
                // empty catch block
            }
        }
        return mInfo;
    }

    static String[] getMechsForProvider(Provider p) {
        String aStr = p.getProperty("JGSS.Mechs");
        if (aStr != null) {
            StringTokenizer st = new StringTokenizer(aStr, ":");
            String[] res = new String[st.countTokens()];
            for (int i = 0; i < res.length; ++i) {
                res[i] = st.nextToken();
            }
            return res;
        }
        return null;
    }

    public String toString() {
        StringBuffer aBuf = new StringBuffer(100);
        aBuf.append("Mechanism oid:\t").append(this.m_oid);
        aBuf.append("\nMechanism alias:\t").append(MechInfo.oidStrToAlias(this.m_oid.toString()));
        aBuf.append("\nMy provider: ");
        if (this._V510CA83 == null) {
            aBuf.append("null");
        } else {
            aBuf.append(this._V510CA83.getInfo());
        }
        aBuf.append("\nSupported Names:\t");
        for (int i = 0; i < this.m_names.length; ++i) {
            aBuf.append(this.m_names[i].toString()).append(" ");
        }
        aBuf.append("\nName Class:\t").append(this._V2395ABD);
        aBuf.append("\nCred Class:\t").append(this._V901D6C2);
        aBuf.append("\nCtxt Class:\t").append(this._V108CA91);
        return aBuf.toString();
    }
}

