/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.misc;

import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.wss.impl.misc.NonceCache;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TimerTask;

public class NonceContainer {
    static Hashtable nonceTable = new Hashtable();

    public static boolean validateAndCacheNonce(String applicationId, String nonce, String created, long maxNonceAge) {
        NonceCache cache = (NonceCache)nonceTable.get(applicationId);
        if (cache == null || cache.wasCanceled()) {
            cache = NonceContainer.initNonceCache(applicationId, maxNonceAge);
        }
        NonceContainer.setNonceCacheCleanup(cache);
        return cache.validateAndCacheNonce(nonce, created);
    }

    private static synchronized NonceCache initNonceCache(String applicationId, long maxNonceAge) {
        NonceCache cache = (NonceCache)nonceTable.get(applicationId);
        if (cache == null) {
            cache = maxNonceAge == 0L ? new NonceCache() : new NonceCache(maxNonceAge);
            nonceTable.put(applicationId, cache);
        } else if (cache.wasCanceled()) {
            cache = maxNonceAge == 0L ? new NonceCache() : new NonceCache(maxNonceAge);
            nonceTable.put(applicationId, cache);
        }
        return cache;
    }

    private static synchronized void setNonceCacheCleanup(NonceCache nonceCache) {
        if (!nonceCache.isScheduled()) {
            DefaultSecurityEnvironmentImpl.nonceCleanupTimer.schedule((TimerTask)nonceCache, nonceCache.getMaxNonceAge(), nonceCache.getMaxNonceAge());
            nonceCache.scheduled(true);
        }
    }

    public static synchronized void cleanup(String applicationId) {
        NonceCache cache = (NonceCache)nonceTable.get(applicationId);
        if (cache != null) {
            cache.cancel();
            nonceTable.remove(applicationId);
        }
    }

    public static synchronized void cleanup() {
        Enumeration keys = nonceTable.keys();
        while (keys.hasMoreElements()) {
            String appId = (String)keys.nextElement();
            NonceCache cache = (NonceCache)nonceTable.get(appId);
            if (cache == null) continue;
            cache.cancel();
        }
        nonceTable.clear();
    }
}

