/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.impl.misc.DefaultRealmAuthenticationAdapter;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.security.auth.Subject;
import javax.xml.soap.SOAPException;

public abstract class RealmAuthenticationAdapter {
    public static final String UsernameAuthenticator = "com.sun.xml.xwss.RealmAuthenticator";
    private static final String SERVLET_CONTEXT_CLASSNAME = "javax.servlet.ServletContext";
    private static final String JAR_PREFIX = "META-INF/";

    protected RealmAuthenticationAdapter() {
    }

    public abstract boolean authenticate(Subject var1, String var2, String var3) throws XWSSecurityException;

    public static RealmAuthenticationAdapter newInstance(Object context) {
        RealmAuthenticationAdapter adapter = null;
        if (context == null) {
            URL url = SecurityUtil.loadFromClasspath("META-INF/services/com.sun.xml.xwss.RealmAuthenticator");
            if (url != null && (adapter = RealmAuthenticationAdapter.loadReamlAuthenticator(url)) != null) {
                return adapter;
            }
            return new DefaultRealmAuthenticationAdapter();
        }
        URL url = SecurityUtil.loadFromContext("/META-INF/services/com.sun.xml.xwss.RealmAuthenticator", context);
        return RealmAuthenticationAdapter.loadReamlAuthenticator(url);
    }

    private static Object newInstance(String className, ClassLoader classLoader) throws SOAPException {
        try {
            Class<?> spiClass = classLoader == null ? Class.forName(className) : classLoader.loadClass(className);
            return spiClass.newInstance();
        }
        catch (ClassNotFoundException x) {
            throw new XWSSecurityRuntimeException("The following RealmAuthenticator: " + className + " specified in META-INF/services of the application archive was not found", x);
        }
        catch (Exception x) {
            throw new XWSSecurityRuntimeException("The following RealmAuthenticator: " + className + " specified in META-INF/services of the application archive could not be instantiated", x);
        }
    }

    private static RealmAuthenticationAdapter loadReamlAuthenticator(URL url) {
        block7: {
            InputStream is = null;
            if (url == null) {
                return null;
            }
            try {
                is = url.openStream();
                if (is == null) break block7;
                try {
                    BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    String factoryClassName = rd.readLine();
                    rd.close();
                    if (factoryClassName != null && !"".equals(factoryClassName)) {
                        Object obj = RealmAuthenticationAdapter.newInstance(factoryClassName, Thread.currentThread().getContextClassLoader());
                        if (!(obj instanceof RealmAuthenticationAdapter)) {
                            throw new Exception("Class :" + factoryClassName + " is not a valid RealmAuthenticationProvider");
                        }
                        return (RealmAuthenticationAdapter)obj;
                    }
                }
                catch (Exception e) {
                    throw new XWSSecurityRuntimeException(e);
                }
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }
}

