/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.incoming;

import com.sun.org.apache.xml.internal.security.utils.RFC2253Parser;
import com.sun.xml.ws.runtime.util.Session;
import com.sun.xml.ws.runtime.util.SessionManager;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.SecurityContextTokenInfo;
import com.sun.xml.ws.security.Token;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.api.reference.DirectReference;
import com.sun.xml.ws.security.opt.api.reference.KeyIdentifier;
import com.sun.xml.ws.security.opt.api.reference.Reference;
import com.sun.xml.ws.security.opt.crypto.jaxb.JAXBStructure;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.crypto.OctectStreamData;
import com.sun.xml.ws.security.opt.impl.crypto.SSEData;
import com.sun.xml.ws.security.opt.impl.incoming.BinarySecurityToken;
import com.sun.xml.ws.security.opt.impl.incoming.DerivedKeyToken;
import com.sun.xml.ws.security.opt.impl.incoming.EncryptedKey;
import com.sun.xml.ws.security.opt.impl.incoming.SAMLAssertion;
import com.sun.xml.ws.security.opt.impl.incoming.StreamWriterData;
import com.sun.xml.ws.security.opt.impl.keyinfo.SecurityTokenReference;
import com.sun.xml.ws.security.opt.impl.util.SOAPUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.XMLUtil;
import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.MLSPolicy;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.DerivedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.IssuedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.KeyBindingBase;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.impl.policy.mls.SecureConversationTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.SymmetricKeyBinding;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.Subject;
import javax.xml.bind.JAXBElement;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;

public class KeySelectorImpl
extends KeySelector {
    private static KeySelectorImpl keyResolver = null;
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.dsig", "com.sun.xml.wss.logging.impl.dsig.LogStrings");
    private static SessionManager sessionManager;

    private KeySelectorImpl() {
    }

    public static KeySelector getInstance() {
        return keyResolver;
    }

    public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
        if (keyInfo == null) {
            if (logger.getLevel() == Level.SEVERE) {
                logger.log(Level.SEVERE, "WSS1317.keyinfo.null");
            }
            throw new KeySelectorException("Null KeyInfo object!");
        }
        try {
            SignatureMethod sm = (SignatureMethod)method;
            List<XMLStructure> list = keyInfo.getContent();
            JAXBFilterProcessingContext wssContext = (JAXBFilterProcessingContext)context.get("http://wss.sun.com#processingContext");
            SecurityPolicy securityPolicy = wssContext.getSecurityPolicy();
            boolean isBSP = false;
            if (securityPolicy != null) {
                isBSP = PolicyTypeUtil.messagePolicy(securityPolicy) ? ((MessagePolicy)securityPolicy).isBSP() : ((WSSPolicy)securityPolicy).isBSP();
            }
            if (isBSP && list.size() > 1) {
                logger.log(Level.SEVERE, "BSP Violation of R5402: KeyInfo MUST have exactly one child");
                throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "BSP Violation of R5402: KeyInfo MUST have exactly one child", null);
            }
            boolean isStr = false;
            for (int i = 0; i < list.size(); ++i) {
                XMLStructure xmlStructure = list.get(i);
                if (xmlStructure instanceof KeyValue) {
                    PublicKey pk = null;
                    try {
                        pk = ((KeyValue)xmlStructure).getPublicKey();
                    }
                    catch (KeyException ke) {
                        throw new KeySelectorException(ke);
                    }
                    if (!KeySelectorImpl.algEquals(sm.getAlgorithm(), pk.getAlgorithm())) continue;
                    return new SimpleKeySelectorResult(pk);
                }
                if (xmlStructure instanceof JAXBStructure) {
                    JAXBElement reference = ((JAXBStructure)xmlStructure).getJAXBElement();
                    if (!KeySelectorImpl.isSecurityTokenReference(reference)) continue;
                    isStr = true;
                    final Key key = KeySelectorImpl.resolve(reference, context, purpose);
                    return new KeySelectorResult(){

                        public Key getKey() {
                            return key;
                        }
                    };
                }
                if (xmlStructure instanceof KeyName) {
                    KeyName keyName = (KeyName)xmlStructure;
                    SecretKey returnKey = wssContext.getSecurityEnvironment().getSecretKey(wssContext.getExtraneousProperties(), keyName.getName(), false);
                    if (returnKey == null) {
                        X509Certificate cert = wssContext.getSecurityEnvironment().getCertificate(wssContext.getExtraneousProperties(), keyName.getName(), false);
                        if (cert == null || !KeySelectorImpl.algEquals(sm.getAlgorithm(), cert.getPublicKey().getAlgorithm())) continue;
                        return new SimpleKeySelectorResult(cert.getPublicKey());
                    }
                    return new SimpleKeySelectorResult(returnKey);
                }
                if (!(xmlStructure instanceof X509Data)) continue;
                Key key = KeySelectorImpl.resolveX509Data(wssContext, (X509Data)xmlStructure, purpose);
                return new SimpleKeySelectorResult(key);
            }
        }
        catch (KeySelectorException kse) {
            throw kse;
        }
        catch (Exception ex) {
            logger.log(Level.FINEST, "Error occurred while resolving keyinformation" + ex.getMessage());
            throw new KeySelectorException(ex);
        }
        throw new KeySelectorException("No KeyValue element found!");
    }

    private static Key resolve(JAXBElement securityTokenReference, XMLCryptoContext context, KeySelector.Purpose purpose) throws KeySelectorException {
        try {
            JAXBFilterProcessingContext wssContext = (JAXBFilterProcessingContext)context.get("http://wss.sun.com#processingContext");
            boolean isPolicyRecipient = wssContext.getMode() == 3;
            SecurityPolicy securityPolicy = wssContext.getSecurityPolicy();
            boolean isBSP = false;
            if (securityPolicy != null) {
                isBSP = PolicyTypeUtil.messagePolicy(securityPolicy) ? ((MessagePolicy)securityPolicy).isBSP() : ((WSSPolicy)securityPolicy).isBSP();
            }
            SecurityTokenReference str = (SecurityTokenReference)securityTokenReference.getValue();
            Reference reference = str.getReference();
            Key returnKey = null;
            if (reference instanceof KeyIdentifier) {
                KeyIdentifier keyId = (KeyIdentifier)reference;
                returnKey = KeySelectorImpl.resolveKeyIdentifier(context, keyId.getValueType(), keyId.getReferenceValue(), null, purpose);
            } else if (reference instanceof DirectReference) {
                DirectReference dReference = (DirectReference)reference;
                String uri = dReference.getURI();
                if (isBSP && !uri.startsWith("#")) {
                    throw new XWSSecurityException("Violation of BSP R5204 : When a SECURITY_TOKEN_REFERENCE uses a Direct Reference to an INTERNAL_SECURITY_TOKEN, it MUST use a Shorthand XPointer Reference");
                }
                String valueType = dReference.getValueType();
                if ("http://schemas.xmlsoap.org/ws/2005/02/sc/dk".equals(valueType)) {
                    valueType = null;
                }
                returnKey = KeySelectorImpl.resolveDirectReference(context, valueType, uri, purpose);
            } else if (reference instanceof com.sun.xml.ws.security.opt.impl.reference.X509IssuerSerial) {
                com.sun.xml.ws.security.opt.impl.reference.X509IssuerSerial xis = (com.sun.xml.ws.security.opt.impl.reference.X509IssuerSerial)((Object)reference);
                BigInteger serialNumber = xis.getX509SerialNumber();
                String issuerName = xis.getX509IssuerName();
                KeySelectorImpl.resolveIssuerSerial(context, issuerName, serialNumber, xis.getId(), purpose);
            } else {
                logger.log(Level.SEVERE, "WSS1308.unsupported.reference.mechanism");
                KeySelectorException xwsse = new KeySelectorException("Key reference mechanism not supported");
                throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_UNSUPPORTED_SECURITY_TOKEN, xwsse.getMessage(), xwsse);
            }
            return returnKey;
        }
        catch (XWSSecurityException xwsExp) {
            logger.log(Level.FINEST, "Error occurred while resolvingkey information", xwsExp);
            throw new KeySelectorException(xwsExp);
        }
        catch (Exception ex) {
            logger.log(Level.FINEST, "Error occurred while resolvingkey information", ex);
            throw new KeySelectorException(ex);
        }
    }

    public static Key resolveIssuerSerial(XMLCryptoContext context, String issuerName, BigInteger serialNumber, String strId, KeySelector.Purpose purpose) throws KeySelectorException {
        Key returnKey = null;
        String normalizedIssuerName = RFC2253Parser.normalize(issuerName);
        try {
            JAXBFilterProcessingContext wssContext = (JAXBFilterProcessingContext)context.get("http://wss.sun.com#processingContext");
            MLSPolicy inferredKB = wssContext.getSecurityContext().getInferredKB();
            AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
            x509Binding.setReferenceType("IssuerSerialNumber");
            if (inferredKB == null) {
                wssContext.getSecurityContext().setInferredKB(x509Binding);
            } else if (PolicyTypeUtil.symmetricKeyBinding(inferredKB)) {
                ((SymmetricKeyBinding)inferredKB).setKeyBinding(x509Binding);
            } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) {
                DerivedTokenKeyBinding dktBind = (DerivedTokenKeyBinding)inferredKB;
                if (dktBind.getOriginalKeyBinding() == null) {
                    dktBind.setOriginalKeyBinding(x509Binding);
                } else if (PolicyTypeUtil.symmetricKeyBinding(dktBind.getOriginalKeyBinding())) {
                    dktBind.getOriginalKeyBinding().setKeyBinding(x509Binding);
                }
            }
            if (purpose == KeySelector.Purpose.VERIFY) {
                wssContext.setExtraneousProperty("requester.serial", serialNumber);
                wssContext.setExtraneousProperty("requester.issuername", normalizedIssuerName);
                X509Certificate cert = wssContext.getSecurityEnvironment().getCertificate(wssContext.getExtraneousProperties(), serialNumber, normalizedIssuerName);
                returnKey = cert.getPublicKey();
                if (strId != null) {
                    byte[] encodedCert = cert.getEncoded();
                    wssContext.getElementCache().put(strId, new OctectStreamData(new String(encodedCert)));
                }
            } else if (purpose == KeySelector.Purpose.SIGN || purpose == KeySelector.Purpose.DECRYPT) {
                returnKey = wssContext.getSecurityEnvironment().getPrivateKey(wssContext.getExtraneousProperties(), serialNumber, normalizedIssuerName);
            }
        }
        catch (Exception ex) {
            logger.log(Level.FINEST, "Error occurred while resolvingkey information", ex);
            throw new KeySelectorException(ex);
        }
        return returnKey;
    }

    public static Key resolveDirectReference(XMLCryptoContext context, String valueType, String uri, KeySelector.Purpose purpose) throws KeySelectorException {
        Key returnKey;
        block57: {
            returnKey = null;
            try {
                JAXBFilterProcessingContext wssContext = (JAXBFilterProcessingContext)context.get("http://wss.sun.com#processingContext");
                MLSPolicy inferredKB = wssContext.getSecurityContext().getInferredKB();
                String wsuId = SOAPUtil.getIdFromFragmentRef(uri);
                boolean isSymmetric = false;
                if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3".equals(valueType) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v1".equals(valueType)) {
                    BinarySecurityToken token = null;
                    token = (BinarySecurityToken)KeySelectorImpl.resolveToken(wsuId, context);
                    if (token == null) {
                        throw new KeySelectorException("Token with Id " + wsuId + "not found");
                    }
                    AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                    x509Binding.setReferenceType("Direct");
                    x509Binding.setValueType(valueType);
                    if (inferredKB == null) {
                        wssContext.getSecurityContext().setInferredKB(x509Binding);
                    } else if (PolicyTypeUtil.symmetricKeyBinding(inferredKB)) {
                        ((SymmetricKeyBinding)inferredKB).setKeyBinding(x509Binding);
                        isSymmetric = true;
                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) {
                        DerivedTokenKeyBinding dktBind = (DerivedTokenKeyBinding)inferredKB;
                        if (dktBind.getOriginalKeyBinding() == null) {
                            dktBind.setOriginalKeyBinding(x509Binding);
                        } else if (PolicyTypeUtil.symmetricKeyBinding(dktBind.getOriginalKeyBinding())) {
                            dktBind.getOriginalKeyBinding().setKeyBinding(x509Binding);
                            isSymmetric = true;
                        }
                    }
                    returnKey = KeySelectorImpl.resolveX509Token(wssContext, token, purpose, isSymmetric);
                    break block57;
                }
                if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey".equals(valueType)) {
                    EncryptedKey token = (EncryptedKey)KeySelectorImpl.resolveToken(wsuId, context);
                    if (token == null) {
                        throw new KeySelectorException("Token with Id " + wsuId + "not found");
                    }
                    KeyBindingBase skBinding = null;
                    boolean saml = wssContext.getSecurityContext().getIsSAMLKeyBinding();
                    if (saml) {
                        skBinding = new AuthenticationTokenPolicy.SAMLAssertionBinding();
                    } else {
                        SymmetricKeyBinding symkBinding = new SymmetricKeyBinding();
                        AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                        symkBinding.setKeyBinding(x509Binding);
                        skBinding = symkBinding;
                    }
                    if (inferredKB == null) {
                        wssContext.getSecurityContext().setInferredKB(skBinding);
                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                        ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(skBinding);
                    }
                    String algo = wssContext.getAlgorithmSuite().getEncryptionAlgorithm();
                    returnKey = token.getKey(algo);
                    break block57;
                }
                if ("http://schemas.xmlsoap.org/ws/2005/02/sc/sct".equals(valueType)) {
                    returnKey = KeySelectorImpl.resolveSCT(wssContext, wsuId, purpose, false);
                    if (returnKey == null) {
                        com.sun.xml.ws.security.opt.impl.incoming.SecurityContextToken scToken = (com.sun.xml.ws.security.opt.impl.incoming.SecurityContextToken)KeySelectorImpl.resolveToken(wsuId, context);
                        if (scToken == null) {
                            throw new KeySelectorException("Token with Id " + wsuId + "not found");
                        }
                        returnKey = KeySelectorImpl.resolveSCT(wssContext, scToken.getSCId(), purpose, true);
                    }
                    SecureConversationTokenKeyBinding sctBinding = new SecureConversationTokenKeyBinding();
                    if (inferredKB == null) {
                        wssContext.getSecurityContext().setInferredKB(sctBinding);
                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) {
                        ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(sctBinding);
                    }
                    return returnKey;
                }
                if ("http://schemas.xmlsoap.org/ws/2005/02/sc/dk".equals(valueType)) {
                    DerivedKeyToken token = (DerivedKeyToken)KeySelectorImpl.resolveToken(wsuId, context);
                    if (token == null) {
                        throw new KeySelectorException("Token with Id " + wsuId + "not found");
                    }
                    DerivedTokenKeyBinding dtkBinding = new DerivedTokenKeyBinding();
                    dtkBinding.setOriginalKeyBinding(token.getInferredKB());
                    if (inferredKB == null) {
                        wssContext.getSecurityContext().setInferredKB(dtkBinding);
                    } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) {
                        // empty if block
                    }
                    returnKey = token.getKey();
                    break block57;
                }
                if (null == valueType) {
                    SecurityHeaderElement token = KeySelectorImpl.resolveToken(wsuId, context);
                    if (token == null) {
                        throw new KeySelectorException("Token with Id " + wsuId + "not found");
                    }
                    if (token instanceof BinarySecurityToken) {
                        AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                        x509Binding.setReferenceType("Direct");
                        if (inferredKB == null) {
                            wssContext.getSecurityContext().setInferredKB(x509Binding);
                        } else if (PolicyTypeUtil.symmetricKeyBinding(inferredKB)) {
                            ((SymmetricKeyBinding)inferredKB).setKeyBinding(x509Binding);
                        } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) {
                            DerivedTokenKeyBinding dktBind = (DerivedTokenKeyBinding)inferredKB;
                            if (dktBind.getOriginalKeyBinding() == null) {
                                dktBind.setOriginalKeyBinding(x509Binding);
                            } else if (PolicyTypeUtil.symmetricKeyBinding(dktBind.getOriginalKeyBinding())) {
                                dktBind.getOriginalKeyBinding().setKeyBinding(x509Binding);
                            }
                        }
                        returnKey = KeySelectorImpl.resolveX509Token(wssContext, (BinarySecurityToken)token, purpose, isSymmetric);
                    } else if (token instanceof EncryptedKey) {
                        SymmetricKeyBinding skBinding = new SymmetricKeyBinding();
                        AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                        skBinding.setKeyBinding(x509Binding);
                        if (inferredKB == null) {
                            wssContext.getSecurityContext().setInferredKB(skBinding);
                        } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                            ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(skBinding);
                        }
                        String algo = wssContext.getAlgorithmSuite().getEncryptionAlgorithm();
                        returnKey = ((EncryptedKey)token).getKey(algo);
                    } else if (token instanceof DerivedKeyToken) {
                        DerivedTokenKeyBinding dtkBinding = new DerivedTokenKeyBinding();
                        dtkBinding.setOriginalKeyBinding(((DerivedKeyToken)token).getInferredKB());
                        if (inferredKB == null) {
                            wssContext.getSecurityContext().setInferredKB(dtkBinding);
                        } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) {
                            // empty if block
                        }
                        returnKey = ((DerivedKeyToken)token).getKey();
                    } else if (token instanceof com.sun.xml.ws.security.opt.impl.incoming.SecurityContextToken) {
                        SecureConversationTokenKeyBinding sctBinding = new SecureConversationTokenKeyBinding();
                        if (inferredKB == null) {
                            wssContext.getSecurityContext().setInferredKB(sctBinding);
                        } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) {
                            ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(sctBinding);
                        }
                        returnKey = KeySelectorImpl.resolveSCT(wssContext, ((com.sun.xml.ws.security.opt.impl.incoming.SecurityContextToken)token).getSCId(), purpose, true);
                    }
                    break block57;
                }
                logger.log(Level.SEVERE, "WSS1307.unsupported.directref.mechanism", new Object[]{valueType});
                throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "unsupported directreference ValueType " + valueType, null);
            }
            catch (XWSSecurityException ex) {
                logger.log(Level.SEVERE, "WSS1377.error.in.resolving.keyinfo", ex);
                throw new KeySelectorException(ex);
            }
            catch (URIReferenceException ex) {
                logger.log(Level.SEVERE, "WSS1377.error.in.resolving.keyinfo", ex);
                throw new KeySelectorException(ex);
            }
        }
        return returnKey;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Key resolveKeyIdentifier(XMLCryptoContext xc, String valueType, String referenceValue, String strId, KeySelector.Purpose purpose) throws KeySelectorException {
        JAXBFilterProcessingContext context = (JAXBFilterProcessingContext)xc.get("http://wss.sun.com#processingContext");
        Object var6_6 = null;
        MLSPolicy inferredKB = context.getSecurityContext().getInferredKB();
        boolean isSymmetric = false;
        try {
            void var6_17;
            void var6_19;
            if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier".equals(valueType) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3SubjectKeyIdentifier".equals(valueType)) {
                AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                x509Binding.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier");
                x509Binding.setReferenceType("Identifier");
                if (inferredKB == null) {
                    context.getSecurityContext().setInferredKB(x509Binding);
                } else if (PolicyTypeUtil.symmetricKeyBinding(inferredKB)) {
                    ((SymmetricKeyBinding)inferredKB).setKeyBinding(x509Binding);
                    isSymmetric = true;
                } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) {
                    DerivedTokenKeyBinding dktBind = (DerivedTokenKeyBinding)inferredKB;
                    if (dktBind.getOriginalKeyBinding() == null) {
                        ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(x509Binding);
                    } else if (PolicyTypeUtil.symmetricKeyBinding(dktBind.getOriginalKeyBinding())) {
                        dktBind.getOriginalKeyBinding().setKeyBinding(x509Binding);
                        isSymmetric = true;
                    }
                }
                if (purpose == KeySelector.Purpose.VERIFY || purpose == KeySelector.Purpose.ENCRYPT) {
                    byte[] keyIdBytes = XMLUtil.getDecodedBase64EncodedData(referenceValue);
                    context.setExtraneousProperty("requester.keyid", new String(keyIdBytes));
                    X509Certificate cert = context.getSecurityEnvironment().getCertificate(context.getExtraneousProperties(), keyIdBytes);
                    if (strId != null) {
                        byte[] encodedCert = cert.getEncoded();
                        context.getElementCache().put(strId, new OctectStreamData(new String(encodedCert)));
                    }
                    if (!isSymmetric) {
                        context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(context), cert);
                    }
                    PublicKey publicKey = cert.getPublicKey();
                    return var6_19;
                }
                if (purpose != KeySelector.Purpose.SIGN) {
                    if (purpose != KeySelector.Purpose.DECRYPT) return var6_19;
                }
                PrivateKey privateKey = context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), XMLUtil.getDecodedBase64EncodedData(referenceValue));
                return var6_19;
            }
            if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1".equals(valueType)) {
                AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                x509Binding.setValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1");
                x509Binding.setReferenceType("Identifier");
                if (inferredKB == null) {
                    context.getSecurityContext().setInferredKB(x509Binding);
                } else if (PolicyTypeUtil.symmetricKeyBinding(inferredKB)) {
                    ((SymmetricKeyBinding)inferredKB).setKeyBinding(x509Binding);
                    isSymmetric = true;
                } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB)) {
                    DerivedTokenKeyBinding dktBind = (DerivedTokenKeyBinding)inferredKB;
                    if (dktBind.getOriginalKeyBinding() == null) {
                        ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(x509Binding);
                    } else if (PolicyTypeUtil.symmetricKeyBinding(dktBind.getOriginalKeyBinding())) {
                        dktBind.getOriginalKeyBinding().setKeyBinding(x509Binding);
                        isSymmetric = true;
                    }
                }
                if (purpose == KeySelector.Purpose.VERIFY || purpose == KeySelector.Purpose.ENCRYPT) {
                    byte[] keyIdBytes = XMLUtil.getDecodedBase64EncodedData(referenceValue);
                    context.setExtraneousProperty("requester.keyid", new String(keyIdBytes));
                    X509Certificate cert = context.getSecurityEnvironment().getCertificate(context.getExtraneousProperties(), keyIdBytes, "Thumbprint");
                    if (!isSymmetric) {
                        context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(context), cert);
                    }
                    PublicKey publicKey = cert.getPublicKey();
                    if (strId == null) return var6_19;
                    byte[] encodedCert = cert.getEncoded();
                    context.getElementCache().put(strId, new OctectStreamData(new String(encodedCert)));
                    return var6_19;
                }
                if (purpose != KeySelector.Purpose.SIGN) {
                    if (purpose != KeySelector.Purpose.DECRYPT) return var6_19;
                }
                PrivateKey privateKey = context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), XMLUtil.getDecodedBase64EncodedData(referenceValue), "Thumbprint");
                return var6_19;
            }
            if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1".equals(valueType)) {
                SymmetricKeyBinding skBinding = new SymmetricKeyBinding();
                AuthenticationTokenPolicy.X509CertificateBinding x509Binding = new AuthenticationTokenPolicy.X509CertificateBinding();
                x509Binding.setReferenceType("Identifier");
                skBinding.setKeyBinding(x509Binding);
                if (inferredKB == null) {
                    context.getSecurityContext().setInferredKB(skBinding);
                } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                    ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(skBinding);
                }
                String ekSha1RefValue = (String)context.getExtraneousProperty("EncryptedKeySHA1");
                Key secretKey = (Key)context.getExtraneousProperty("SecretKey");
                String keyRefValue = referenceValue;
                if (ekSha1RefValue != null && secretKey != null) {
                    if (!ekSha1RefValue.equals(keyRefValue)) return var6_19;
                    Key key = secretKey;
                    return var6_19;
                }
                String message = "EncryptedKeySHA1 reference not correct";
                logger.log(Level.SEVERE, "WSS1306:unsupported.KeyIdentifier.Reference.Type.encountered", new Object[]{message});
                throw new KeySelectorException(message);
            }
            if (!"http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(valueType)) {
                if (!"http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(valueType)) return var6_19;
            }
            IssuedTokenKeyBinding itkBinding = new IssuedTokenKeyBinding();
            if (inferredKB == null) {
                if (context.hasIssuedToken()) {
                    context.getSecurityContext().setInferredKB(itkBinding);
                } else {
                    context.getSecurityContext().setInferredKB(new AuthenticationTokenPolicy.SAMLAssertionBinding());
                }
            } else if (PolicyTypeUtil.derivedTokenKeyBinding(inferredKB) && ((DerivedTokenKeyBinding)inferredKB).getOriginalKeyBinding() == null) {
                ((DerivedTokenKeyBinding)inferredKB).setOriginalKeyBinding(itkBinding);
            }
            SecurityHeaderElement she = KeySelectorImpl.resolveToken(referenceValue, xc);
            if (she != null && she instanceof SAMLAssertion) {
                SAMLAssertion samlAssertion = (SAMLAssertion)she;
                Key key = samlAssertion.getKey();
                if (strId != null && strId.length() > 0) {
                    SSEData data = new SSEData(samlAssertion, false, context.getNamespaceContext());
                    context.getElementCache().put(strId, data);
                }
            } else {
                HashMap sentSamlKeys = (HashMap)context.getExtraneousProperty("stored_saml_keys");
                if (sentSamlKeys != null) {
                    context.getSecurityContext().setIsSAMLKeyBinding(true);
                    Key key = (Key)sentSamlKeys.get(referenceValue);
                }
            }
            if (!context.hasIssuedToken()) return var6_19;
            SecurityTokenReference str = new SecurityTokenReference(context.getSOAPVersion());
            com.sun.xml.ws.security.opt.impl.reference.KeyIdentifier ki = new com.sun.xml.ws.security.opt.impl.reference.KeyIdentifier(context.getSOAPVersion());
            ki.setValueType(valueType);
            ki.setReferenceValue(referenceValue);
            str.setReference(ki);
            SecurityUtil.initInferredIssuedTokenContext(context, str, (Key)var6_17);
            return var6_19;
        }
        catch (XWSSecurityException ex) {
            logger.log(Level.SEVERE, "WSS1377.error.in.resolving.keyinfo", ex);
            throw new KeySelectorException(ex);
        }
        catch (URIReferenceException ex) {
            logger.log(Level.SEVERE, "WSS1377.error.in.resolving.keyinfo", ex);
            throw new KeySelectorException(ex);
        }
        catch (CertificateEncodingException ex) {
            logger.log(Level.SEVERE, "WSS1377.error.in.resolving.keyinfo", ex);
            throw new KeySelectorException(ex);
        }
    }

    private static boolean algEquals(String algURI, String algName) {
        if (algName.equalsIgnoreCase("DSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
            return true;
        }
        return algName.equalsIgnoreCase("RSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
    }

    private static Key resolveX509Token(JAXBFilterProcessingContext context, BinarySecurityToken token, KeySelector.Purpose purpose, boolean isSymmetric) throws XWSSecurityException {
        X509Certificate cert = token.getCertificate();
        if (cert == null) {
            cert = SOAPUtil.getCertificateFromToken(token);
        }
        if (purpose == KeySelector.Purpose.VERIFY) {
            if (!isSymmetric) {
                context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(context), cert);
            }
            return cert.getPublicKey();
        }
        if (purpose == KeySelector.Purpose.SIGN || purpose == KeySelector.Purpose.DECRYPT) {
            return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), cert);
        }
        return null;
    }

    private static Key resolveX509Data(JAXBFilterProcessingContext context, X509Data x509Data, KeySelector.Purpose purpose) throws KeySelectorException {
        X509Certificate cert = null;
        try {
            List<?> data = x509Data.getContent();
            for (Object content : data) {
                if (content instanceof X509Certificate) {
                    cert = (X509Certificate)content;
                } else if (content instanceof byte[]) {
                    byte[] ski = (byte[])content;
                    if (purpose == KeySelector.Purpose.VERIFY) {
                        cert = context.getSecurityEnvironment().getCertificate(context.getExtraneousProperties(), ski);
                        context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(context), cert);
                        return cert.getPublicKey();
                    }
                    if (purpose == KeySelector.Purpose.SIGN) {
                        return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), ski);
                    }
                } else {
                    if (content instanceof String) {
                        logger.log(Level.SEVERE, "WSS1312.unsupported.keyinfo");
                        throw new KeySelectorException("X509SubjectName child element of X509Data is not yet supported by our implementation");
                    }
                    if (content instanceof X509IssuerSerial) {
                        X509IssuerSerial xis = (X509IssuerSerial)content;
                        if (purpose == KeySelector.Purpose.VERIFY) {
                            cert = context.getSecurityEnvironment().getCertificate(context.getExtraneousProperties(), xis.getSerialNumber(), xis.getIssuerName());
                            context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(context), cert);
                            return cert.getPublicKey();
                        }
                        if (purpose == KeySelector.Purpose.SIGN) {
                            return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), xis.getSerialNumber(), xis.getIssuerName());
                        }
                    } else {
                        logger.log(Level.SEVERE, "WSS1312.unsupported.keyinfo");
                        throw new KeySelectorException("Unsupported child element of X509Data encountered");
                    }
                }
                if (purpose == KeySelector.Purpose.VERIFY) {
                    context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(context), cert);
                    return cert.getPublicKey();
                }
                if (purpose != KeySelector.Purpose.SIGN) continue;
                return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), cert);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WSS1314.illegal.x509.data", e.getMessage());
            throw new KeySelectorException(e);
        }
        return null;
    }

    protected static SecurityHeaderElement resolveToken(final String uri, XMLCryptoContext context) throws URIReferenceException, XWSSecurityException {
        URIDereferencer resolver = context.getURIDereferencer();
        URIReference uriRef = new URIReference(){

            public String getURI() {
                return uri;
            }

            public String getType() {
                return null;
            }
        };
        JAXBFilterProcessingContext wssContext = (JAXBFilterProcessingContext)context.get("http://wss.sun.com#processingContext");
        try {
            StreamWriterData data = (StreamWriterData)resolver.dereference(uriRef, context);
            if (data == null) {
                return null;
            }
            Object derefData = data.getDereferencedObject();
            SecurityHeaderElement she = null;
            if (derefData instanceof SecurityHeaderElement) {
                she = (SecurityHeaderElement)derefData;
            }
            if (she == null) {
                logger.log(Level.SEVERE, "WSS1304.FC_SECURITY_TOKEN_UNAVAILABLE");
                throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_SECURITY_TOKEN_UNAVAILABLE, "Referenced Security Token could not be retrieved", null);
            }
            if ("BinarySecurityToken".equals(she.getLocalPart())) {
                BinarySecurityToken token = (BinarySecurityToken)she;
                X509Certificate cert = null;
                cert = token.getCertificate();
                if (!wssContext.getSecurityEnvironment().validateCertificate(cert)) {
                    throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "Certificate validation failed", null);
                }
                return token;
            }
            if ("EncryptedKey".equals(she.getLocalPart())) {
                return (EncryptedKey)she;
            }
            if ("SecurityContextToken".equals(she.getLocalPart())) {
                return (com.sun.xml.ws.security.opt.impl.incoming.SecurityContextToken)she;
            }
            if ("DerivedKeyToken".equals(she.getLocalPart())) {
                return (DerivedKeyToken)she;
            }
            if ("Assertion".equals(she.getLocalPart())) {
                return she;
            }
        }
        catch (URIReferenceException ure) {
            logger.log(Level.SEVERE, "WSS1304.FC_SECURITY_TOKEN_UNAVAILABLE", ure);
            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_SECURITY_TOKEN_UNAVAILABLE, "Referenced Security Token could not be retrieved", ure);
        }
        if (logger.isLoggable(Level.SEVERE)) {
            logger.log(Level.SEVERE, "WSS1305.UnSupported.security.token");
        }
        throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_UNSUPPORTED_SECURITY_TOKEN, "A Unsupported token was provided ", null);
    }

    private static boolean isSecurityTokenReference(JAXBElement reference) {
        String local = reference.getName().getLocalPart();
        String uri = reference.getName().getNamespaceURI();
        return "SecurityTokenReference".equals(local) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(uri);
    }

    private static Key resolveSCT(JAXBFilterProcessingContext wssContext, String scId, KeySelector.Purpose purpose, boolean checkSession) throws XWSSecurityException {
        IssuedTokenContext ctx = null;
        Enumeration elements = wssContext.getIssuedTokenContextMap().elements();
        while (elements.hasMoreElements()) {
            IssuedTokenContext ictx = (IssuedTokenContext)elements.nextElement();
            Token tok = ictx.getSecurityToken();
            String ctxid = null;
            if (!(tok instanceof SecurityContextToken) || !(ctxid = ((SecurityContextToken)tok).getIdentifier().toString()).equals(scId)) continue;
            ctx = ictx;
            break;
        }
        if (checkSession && ctx == null) {
            Session session = sessionManager.getSession(scId);
            if (session != null) {
                SecurityContextTokenInfo sctInfo = session.getSecurityInfo();
                ctx = sctInfo.getIssuedTokenContext();
                wssContext.getIssuedTokenContextMap().put(scId, ctx);
            } else {
                throw new XWSSecurityException("Could not locate SecureConversation session for Id:" + scId);
            }
        }
        if (ctx == null) {
            return null;
        }
        Subject subj = ctx.getRequestorSubject();
        if (subj != null && wssContext.getExtraneousProperty("SCBOOTSTRAP_CRED_IN_SUBJ") == null) {
            wssContext.getSecurityEnvironment().updateOtherPartySubject(SecurityUtil.getSubject(wssContext.getExtraneousProperties()), subj);
            wssContext.getExtraneousProperties().put("SCBOOTSTRAP_CRED_IN_SUBJ", "true");
        }
        byte[] proofKey = ctx.getProofKey();
        wssContext.setExtraneousProperty("Incoming_SCT", ctx.getSecurityToken());
        if (proofKey == null) {
            throw new XWSSecurityException("Could not locate SecureConversation session for Id:" + scId);
        }
        String algo = "AES";
        if (wssContext.getAlgorithmSuite() != null) {
            algo = SecurityUtil.getSecretKeyAlgorithm(wssContext.getAlgorithmSuite().getEncryptionAlgorithm());
        }
        SecretKeySpec key = new SecretKeySpec(proofKey, algo);
        return key;
    }

    static {
        keyResolver = new KeySelectorImpl();
        sessionManager = SessionManager.getSessionManager();
    }

    private static class SimpleKeySelectorResult
    implements KeySelectorResult {
        private Key pk;

        SimpleKeySelectorResult(Key pk) {
            this.pk = pk;
        }

        public Key getKey() {
            return this.pk;
        }
    }
}

