/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.hk2.config;

import static java.lang.annotation.ElementType.METHOD;
import java.lang.annotation.Retention;
import static java.lang.annotation.RetentionPolicy.RUNTIME;
import java.lang.annotation.Target;

import javax.management.DescriptorKey;

/**
    Units annotation to be used on @Configured interfaces.  Units are strings because
    they are an unbounded set, but do try to use the provided values for consistency.
    
   @author Lloyd Chambers
 */
@Retention(RUNTIME)
@Target({METHOD})
public @interface Units {
    public final String MILLISECONDS = "milliseconds";
    public final String SECONDS = "seconds";
    public final String MINUTES = "minutes";
    public final String HOURS = "hours";
    public final String DAYS = "days";
    
    public final String BYTES = "bytes";
    public final String KILOBYTES = "kilobytes";
    public final String MEGABYTES = "megabytes";
    public final String GIGABYTES = "gigabytes";
    
    /** value is an arbitrary count */
    public final String COUNT = "count";
    
    /**
    Units should always be lower-case and appropriate for human viewing.  Suggested units:
    <ul>
        <li>"seconds", "milliseconds", "minutes", "hours", "days"</li>
        <li>"count"</li>
        <li>"bytes", "kilobytes", "megabytes", "gigabytes"</li>
    </ul>
    */
    @DescriptorKey("units")
    public String units();
}






