/*
 * Decompiled with CFR 0.152.
 */
package com.sumitanantwar.android.xml_font_views;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v7.widget.AppCompatButton;
import android.util.AttributeSet;
import com.sumitanantwar.android.xml_font_views.FontManager;
import com.sumitanantwar.android.xml_font_views.R;

public class XMLFontButton
extends AppCompatButton {
    private final Context mContext;
    private String mFontFile;

    public XMLFontButton(Context context) {
        this(context, null);
    }

    public XMLFontButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.initWithAttributes(attrs, 0);
    }

    public XMLFontButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.initWithAttributes(attrs, defStyleAttr);
    }

    private void initWithAttributes(AttributeSet attrs, int defStyleAttr) {
        TypedArray attributes = this.mContext.getTheme().obtainStyledAttributes(attrs, R.styleable.XMLFontButton, defStyleAttr, 0);
        String fontFilename = attributes.getString(R.styleable.XMLFontButton_font_file);
        if (fontFilename != null) {
            this.setFontFile(fontFilename);
        }
        attributes.recycle();
    }

    public void setFontFile(String filename) {
        this.mFontFile = filename;
        this.setTypeface(FontManager.getTypeFaceForFont(this.mContext, filename));
    }

    public String getFontFile() {
        return this.mFontFile;
    }
}

