/*
 * Decompiled with CFR 0.152.
 */
package com.sumitanantwar.android.xml_font_views;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Map;

public class FontManager {
    private static Map<String, Typeface> FONT_MAP = new HashMap<String, Typeface>();

    public static Typeface getTypeFaceForFont(Context context, String fontFile) {
        if (fontFile.length() <= 0) {
            throw new InvalidParameterException("Font filename cannot be null or empty");
        }
        if (!FONT_MAP.containsKey(fontFile)) {
            try {
                Typeface typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)("fonts/" + fontFile));
                FONT_MAP.put(fontFile, typeface);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Font file not found.\nMake sure that %s exists under \"assets/fonts/\" folder", fontFile));
            }
        }
        return FONT_MAP.get(fontFile);
    }
}

