/*
 * Decompiled with CFR 0.152.
 */
package com.sumitanantwar.android.xml_font_views;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.TextView;
import com.sumitanantwar.android.xml_font_views.FontManager;
import com.sumitanantwar.android.xml_font_views.R;

public class XMLFontTextView
extends TextView {
    private final Context mContext;
    private String mFontFile;

    public XMLFontTextView(Context context) {
        this(context, null);
    }

    public XMLFontTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.initWithAttributes(attrs, 0);
    }

    public XMLFontTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.initWithAttributes(attrs, defStyleAttr);
    }

    private void initWithAttributes(AttributeSet attrs, int defStyleAttr) {
        TypedArray attributes = this.mContext.getTheme().obtainStyledAttributes(attrs, R.styleable.XMLFontTextView, defStyleAttr, 0);
        String fontFilename = attributes.getString(R.styleable.XMLFontTextView_font_file);
        if (fontFilename != null) {
            this.setFontFile(fontFilename);
        }
        attributes.recycle();
    }

    public void setFontFile(String filename) {
        this.mFontFile = filename;
        this.setTypeface(FontManager.getTypeFaceForFont(this.mContext, filename));
    }

    public String getFontFile() {
        return this.mFontFile;
    }
}

