/*
 * Decompiled with CFR 0.152.
 */
package com.sumitanantwar.android.android_xml_font_views;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.TextView;
import com.sumitanantwar.android.android_xml_font_views.FontManager;
import com.sumitanantwar.android.android_xml_font_views.R;

public class XMLTextView
extends TextView {
    private final Context mContext;
    private String mFontName;

    public XMLTextView(Context context) {
        this(context, null);
    }

    public XMLTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.initWithAttributes(attrs, 0);
    }

    public XMLTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.initWithAttributes(attrs, defStyleAttr);
    }

    private void initWithAttributes(AttributeSet attrs, int defStyleAttr) {
        TypedArray attributes = this.mContext.getTheme().obtainStyledAttributes(attrs, R.styleable.XMLFontTextView, defStyleAttr, 0);
        String fontName = attributes.getString(R.styleable.XMLFontTextView_font_name);
        if (fontName != null) {
            this.setFontName(fontName);
        }
        attributes.recycle();
    }

    public void setFontName(String fontName) {
        this.mFontName = fontName;
        this.setTypeface(FontManager.getTypeFaceForFont(this.mContext, fontName));
    }

    public String getFontName() {
        return this.mFontName;
    }
}

