[wire-runtime](../../../index.md) / [com.squareup.wire](../../index.md) / [ProtoAdapter](../index.md) / [UnsupportedTypeProtoAdapter](./index.md)

# UnsupportedTypeProtoAdapter

`class UnsupportedTypeProtoAdapter : `[`ProtoAdapter`](../index.md)`<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`>`

**Platform and version requirements:** JVM

Stub [ProtoAdapter](../index.md) for Wire types which are typeliased to `java.time` types on the JVM
such as [Duration](../../-duration/index.md) and [Instant](../../-instant/index.md). This proto adapter is used when the corresponding
`java.time` type is missing from the JVM classpath.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `UnsupportedTypeProtoAdapter()`<br>Stub [ProtoAdapter](../index.md) for Wire types which are typeliased to `java.time` types on the JVM such as [Duration](../../-duration/index.md) and [Instant](../../-instant/index.md). This proto adapter is used when the corresponding `java.time` type is missing from the JVM classpath. |

### Inherited Properties

| Name | Summary |
|---|---|
| [identity](../identity.md)<br>(JVM, js, native) | `val identity: `[`E`](../index.md#E)`?`<br>A special value that is used when a field is absent from an encoded proto3 message. When encoding a proto3 message, fields that hold this value will be omitted. |
| [syntax](../syntax.md)<br>(JVM, js, native) | `val syntax: `[`Syntax`](../../-syntax/index.md)<br>Identifies the syntax in which [type](../type.md) is defined in the proto schema. This string contains either "proto2" or "proto3". |
| [type](../type.md)<br>(JVM, js, native) | `val type: `[`KClass`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)`<*>?` |
| [typeUrl](../type-url.md)<br>(JVM, js, native) | `val typeUrl: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?`<br>Identifies this type for inclusion in a `google.protobuf.Any`. This is a string like "type.googleapis.com/packagename.messagename" or null if this type is either not a message (such as scalars and enums), or was code-generated before Wire 3.2 which introduced support for type URLS. |

### Functions

| Name | Summary |
|---|---|
| [decode](decode.md) | `fun decode(reader: <ERROR CLASS>): `[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html) |
| [encode](encode.md) | `fun encode(writer: <ERROR CLASS>, value: `[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`): `[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html) |
| [encodedSize](encoded-size.md) | `fun encodedSize(value: `[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`): `[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html) |
| [redact](redact.md) | `fun redact(value: `[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`): `[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html) |

### Inherited Functions

| Name | Summary |
|---|---|
| [asPacked](../as-packed.md)<br>(JVM, js, native) | `fun asPacked(): `[`ProtoAdapter`](../index.md)`<`[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`E`](../index.md#E)`>>`<br>Returns an adapter for `E` but as a packed, repeated value. |
| [asRepeated](../as-repeated.md)<br>(JVM, js, native) | `fun asRepeated(): `[`ProtoAdapter`](../index.md)`<`[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`E`](../index.md#E)`>>`<br>Returns an adapter for `E` but as a repeated value. |
| [decode](../decode.md)<br>(JVM) | `fun decode(bytes: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`): `[`E`](../index.md#E)<br>Read an encoded message from `bytes`.`fun decode(stream: `[`InputStream`](http://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html)`): `[`E`](../index.md#E) |
| [encode](../encode.md)<br>(JVM) | `fun encode(value: `[`E`](../index.md#E)`): `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>Encode `value` as a `byte[]`.`fun encode(stream: `[`OutputStream`](http://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html)`, value: `[`E`](../index.md#E)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [encodeByteString](../encode-byte-string.md)<br>(JVM, js, native) | `fun encodeByteString(value: `[`E`](../index.md#E)`): <ERROR CLASS>`<br>Encode `value` as a [ByteString](#). |
| [encodeWithTag](../encode-with-tag.md)<br>(JVM, js, native) | `open actual fun encodeWithTag(writer: <ERROR CLASS>, tag: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, value: `[`E`](../index.md#E)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [encodedSizeWithTag](../encoded-size-with-tag.md)<br>(JVM, js, native) | `open fun encodedSizeWithTag(tag: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, value: `[`E`](../index.md#E)`?): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>The size of `tag` and `value` in the wire format. This size includes the tag, type, length-delimited prefix (should the type require one), and value. Returns 0 if `value` is null. |
| [toString](../to-string.md)<br>(JVM, js, native) | `open fun toString(value: `[`E`](../index.md#E)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns a human-readable version of the given `value`. |
