[wire-runtime](../../index.md) / [com.squareup.wire](../index.md) / [Instant](./index.md)

# Instant

`expect class Instant`

This represents a timestamp, though we use the name 'instant' in the runtime because that's what
the JVM libraries use, and 'Timestamp' means something else on that platform.

### Functions

| Name | Summary |
|---|---|
| [getEpochSecond](-instant/get-epoch-second.md)<br>(js, native) | `fun getEpochSecond(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the number of seconds since the UNIX epoch (1970-01-01T00:00:00Z) if this value is positive, or until the UNIX epoch if this value is negative. |
| [getNano](-instant/get-nano.md)<br>(js, native) | `fun getNano(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Returns a value in the range `[0..1,000,000,000)` indicating the fraction of a second that is added to [getEpochSecond](get-epoch-second.md). |
