/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.testing;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.internal.Throwables;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;

public class InstallUncaughtExceptionHandlerListener
extends RunListener {
    private Thread.UncaughtExceptionHandler oldDefaultUncaughtExceptionHandler;
    private Description lastTestStarted;
    private final Map<Throwable, String> exceptions = new LinkedHashMap<Throwable, String>();

    public void testRunStarted(Description description) {
        System.err.println("Installing aggressive uncaught exception handler");
        this.oldDefaultUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler((thread, throwable) -> {
            StringWriter errorText = new StringWriter(256);
            errorText.append("Uncaught exception in OkHttp thread \"");
            errorText.append(thread.getName());
            errorText.append("\"\n");
            throwable.printStackTrace(new PrintWriter(errorText));
            errorText.append("\n");
            if (this.lastTestStarted != null) {
                errorText.append("Last test to start was: ");
                errorText.append(this.lastTestStarted.getDisplayName());
                errorText.append("\n");
            }
            System.err.print(errorText.toString());
            Map<Throwable, String> map = this.exceptions;
            synchronized (map) {
                this.exceptions.put(throwable, this.lastTestStarted.getDisplayName());
            }
        });
    }

    public void testStarted(Description description) {
        this.lastTestStarted = description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRunFinished(Result result) throws Exception {
        Thread.setDefaultUncaughtExceptionHandler(this.oldDefaultUncaughtExceptionHandler);
        System.err.println("Uninstalled aggressive uncaught exception handler");
        Map<Throwable, String> map = this.exceptions;
        synchronized (map) {
            if (!this.exceptions.isEmpty()) {
                throw Throwables.rethrowAsException((Throwable)this.exceptions.keySet().iterator().next());
            }
        }
    }
}

