/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute.internal;

import com.speedment.runtime.compute.ToString;
import com.speedment.runtime.compute.expression.JoiningExpression;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

public final class BinaryJoiningExpressionImpl<T>
implements JoiningExpression<T> {
    private final CharSequence separator;
    private final CharSequence prefix;
    private final CharSequence suffix;
    private final ToString<T> first;
    private final ToString<T> second;

    public BinaryJoiningExpressionImpl(CharSequence separator, CharSequence prefix, CharSequence suffix, ToString<T> first, ToString<T> second) {
        this.separator = Objects.requireNonNull(separator);
        this.prefix = Objects.requireNonNull(prefix);
        this.suffix = Objects.requireNonNull(suffix);
        this.first = Objects.requireNonNull(first);
        this.second = Objects.requireNonNull(second);
    }

    @Override
    public List<ToString<T>> expressions() {
        return Arrays.asList(this.first, this.second);
    }

    @Override
    public CharSequence prefix() {
        return this.prefix;
    }

    @Override
    public CharSequence suffix() {
        return this.suffix;
    }

    @Override
    public CharSequence separator() {
        return this.separator;
    }

    @Override
    public String apply(T object) {
        StringJoiner joiner = new StringJoiner(this.separator, this.prefix, this.suffix);
        joiner.add((CharSequence)this.first.apply((Object)object));
        joiner.add((CharSequence)this.second.apply((Object)object));
        return joiner.toString();
    }
}

