/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute;

import com.speedment.runtime.compute.ToByte;
import com.speedment.runtime.compute.ToDouble;
import com.speedment.runtime.compute.ToInt;
import com.speedment.runtime.compute.ToLongNullable;
import com.speedment.runtime.compute.expression.Expression;
import com.speedment.runtime.compute.expression.ExpressionType;
import com.speedment.runtime.compute.expression.Expressions;
import com.speedment.runtime.compute.internal.expression.CastUtil;
import com.speedment.runtime.compute.internal.expression.ComposedUtil;
import com.speedment.runtime.compute.internal.expression.MapperUtil;
import com.speedment.runtime.compute.trait.HasAbs;
import com.speedment.runtime.compute.trait.HasAsDouble;
import com.speedment.runtime.compute.trait.HasAsInt;
import com.speedment.runtime.compute.trait.HasAsLong;
import com.speedment.runtime.compute.trait.HasCompare;
import com.speedment.runtime.compute.trait.HasCompose;
import com.speedment.runtime.compute.trait.HasDivide;
import com.speedment.runtime.compute.trait.HasHash;
import com.speedment.runtime.compute.trait.HasMap;
import com.speedment.runtime.compute.trait.HasMapToDouble;
import com.speedment.runtime.compute.trait.HasMinus;
import com.speedment.runtime.compute.trait.HasMultiply;
import com.speedment.runtime.compute.trait.HasNegate;
import com.speedment.runtime.compute.trait.HasPlus;
import com.speedment.runtime.compute.trait.HasPow;
import com.speedment.runtime.compute.trait.HasSign;
import com.speedment.runtime.compute.trait.HasSqrt;
import java.util.function.Function;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ToLongFunction;

@FunctionalInterface
public interface ToLong<T>
extends Expression<T>,
ToLongFunction<T>,
HasAsDouble<T>,
HasAsInt<T>,
HasAsLong<T>,
HasAbs<ToLong<T>>,
HasSign<ToByte<T>>,
HasSqrt<ToDouble<T>>,
HasNegate<ToLong<T>>,
HasPow<T>,
HasPlus<T>,
HasMinus<T>,
HasMultiply<T>,
HasDivide<T>,
HasMap<T, LongUnaryOperator, ToLong<T>>,
HasMapToDouble<T, LongToDoubleFunction>,
HasHash<T>,
HasCompare<T>,
HasCompose<T> {
    public static <T> ToLong<T> of(ToLongFunction<T> lambda) {
        if (lambda instanceof ToLong) {
            return (ToLong)lambda;
        }
        return lambda::applyAsLong;
    }

    @Override
    public long applyAsLong(T var1);

    @Override
    default public ExpressionType expressionType() {
        return ExpressionType.LONG;
    }

    @Override
    default public ToDouble<T> asDouble() {
        return CastUtil.castLongToDouble(this);
    }

    @Override
    default public ToInt<T> asInt() {
        return CastUtil.castLongToInt(this);
    }

    @Override
    default public ToLong<T> asLong() {
        return this;
    }

    @Override
    default public ToDouble<T> mapToDouble(LongToDoubleFunction operator) {
        return MapperUtil.mapLongToDouble(this, operator);
    }

    @Override
    default public ToLong<T> map(LongUnaryOperator operator) {
        return MapperUtil.mapLong(this, operator);
    }

    @Override
    default public ToLong<T> abs() {
        return Expressions.abs(this);
    }

    @Override
    default public ToByte<T> sign() {
        return Expressions.sign(this);
    }

    @Override
    default public ToDouble<T> sqrt() {
        return Expressions.sqrt(this);
    }

    @Override
    default public ToDouble<T> pow(int power) {
        return Expressions.pow(this, power);
    }

    @Override
    default public ToDouble<T> pow(double power) {
        return Expressions.pow(this, power);
    }

    @Override
    default public ToDouble<T> pow(ToInt<T> power) {
        return Expressions.pow(this, power);
    }

    @Override
    default public ToDouble<T> pow(ToDouble<T> power) {
        return Expressions.pow(this, power);
    }

    @Override
    default public ToLong<T> plus(byte other) {
        return Expressions.plus(this, other);
    }

    @Override
    default public ToLong<T> plus(ToByte<T> other) {
        return Expressions.plus(this, other.asLong());
    }

    @Override
    default public ToLong<T> plus(int other) {
        return Expressions.plus(this, other);
    }

    @Override
    default public ToLong<T> plus(ToInt<T> other) {
        return Expressions.plus(this, other);
    }

    @Override
    default public ToLong<T> plus(long other) {
        return Expressions.plus(this, other);
    }

    @Override
    default public ToLong<T> plus(ToLong<T> other) {
        return Expressions.plus(this, other);
    }

    @Override
    default public ToDouble<T> plus(double other) {
        return Expressions.plus(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> plus(ToDouble<T> other) {
        return Expressions.plus(this.asDouble(), other);
    }

    @Override
    default public ToLong<T> minus(byte other) {
        return Expressions.minus(this, other);
    }

    @Override
    default public ToLong<T> minus(ToByte<T> other) {
        return Expressions.minus(this, other.asLong());
    }

    @Override
    default public ToLong<T> minus(int other) {
        return Expressions.minus(this, other);
    }

    @Override
    default public ToLong<T> minus(ToInt<T> other) {
        return Expressions.minus(this, other);
    }

    @Override
    default public ToLong<T> minus(long other) {
        return Expressions.minus(this, other);
    }

    @Override
    default public ToLong<T> minus(ToLong<T> other) {
        return Expressions.minus(this, other);
    }

    @Override
    default public ToDouble<T> minus(double other) {
        return Expressions.minus(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> minus(ToDouble<T> other) {
        return Expressions.minus(this.asDouble(), other);
    }

    @Override
    default public ToLong<T> multiply(byte other) {
        return Expressions.multiply(this, other);
    }

    @Override
    default public ToLong<T> multiply(ToByte<T> other) {
        return Expressions.multiply(this, other.asLong());
    }

    @Override
    default public ToLong<T> multiply(int other) {
        return Expressions.multiply(this, other);
    }

    @Override
    default public ToLong<T> multiply(ToInt<T> other) {
        return Expressions.multiply(this, other);
    }

    @Override
    default public ToLong<T> multiply(long other) {
        return Expressions.multiply(this, other);
    }

    @Override
    default public ToLong<T> multiply(ToLong<T> other) {
        return Expressions.multiply(this, other);
    }

    @Override
    default public ToDouble<T> multiply(double other) {
        return Expressions.multiply(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> multiply(ToDouble<T> other) {
        return Expressions.multiply(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> divide(int divisor) {
        return Expressions.divide(this, divisor);
    }

    @Override
    default public ToDouble<T> divide(ToInt<T> divisor) {
        return Expressions.divide(this, divisor);
    }

    @Override
    default public ToDouble<T> divide(long divisor) {
        return Expressions.divide(this, divisor);
    }

    @Override
    default public ToDouble<T> divide(ToLong<T> divisor) {
        return Expressions.divide(this, divisor);
    }

    @Override
    default public ToDouble<T> divide(double divisor) {
        return Expressions.divide(this, divisor);
    }

    @Override
    default public ToDouble<T> divide(ToDouble<T> divisor) {
        return Expressions.divide(this, divisor);
    }

    @Override
    default public ToLong<T> negate() {
        return Expressions.negate(this);
    }

    @Override
    default public long hash(T object) {
        long l = this.applyAsLong(object);
        return (int)(l ^ l >>> 32);
    }

    @Override
    default public int compare(T first, T second) {
        return Long.compare(this.applyAsLong(first), this.applyAsLong(second));
    }

    @Override
    default public <V> ToLongNullable<V> compose(Function<? super V, ? extends T> before) {
        Function<? super V, ? extends T> casted = before;
        return ComposedUtil.composeToLong(casted, this);
    }
}

