/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute;

import com.speedment.runtime.compute.ToBigDecimalNullable;
import com.speedment.runtime.compute.ToByte;
import com.speedment.runtime.compute.ToDouble;
import com.speedment.runtime.compute.ToInt;
import com.speedment.runtime.compute.ToLong;
import com.speedment.runtime.compute.expression.Expression;
import com.speedment.runtime.compute.expression.ExpressionType;
import com.speedment.runtime.compute.expression.Expressions;
import com.speedment.runtime.compute.internal.expression.AbsUtil;
import com.speedment.runtime.compute.internal.expression.CastUtil;
import com.speedment.runtime.compute.internal.expression.ComposedUtil;
import com.speedment.runtime.compute.internal.expression.MapperUtil;
import com.speedment.runtime.compute.trait.HasAbs;
import com.speedment.runtime.compute.trait.HasAsDouble;
import com.speedment.runtime.compute.trait.HasAsInt;
import com.speedment.runtime.compute.trait.HasAsLong;
import com.speedment.runtime.compute.trait.HasCompare;
import com.speedment.runtime.compute.trait.HasCompose;
import com.speedment.runtime.compute.trait.HasDivide;
import com.speedment.runtime.compute.trait.HasHash;
import com.speedment.runtime.compute.trait.HasMap;
import com.speedment.runtime.compute.trait.HasMapToDouble;
import com.speedment.runtime.compute.trait.HasMinus;
import com.speedment.runtime.compute.trait.HasMultiply;
import com.speedment.runtime.compute.trait.HasNegate;
import com.speedment.runtime.compute.trait.HasPlus;
import com.speedment.runtime.compute.trait.HasPow;
import com.speedment.runtime.compute.trait.HasSign;
import com.speedment.runtime.compute.trait.HasSqrt;
import java.math.BigDecimal;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.UnaryOperator;

@FunctionalInterface
public interface ToBigDecimal<T>
extends Expression<T>,
Function<T, BigDecimal>,
HasAsInt<T>,
HasAsLong<T>,
HasAsDouble<T>,
HasAbs<ToBigDecimal<T>>,
HasSign<ToByte<T>>,
HasSqrt<ToDouble<T>>,
HasNegate<ToBigDecimal<T>>,
HasPow<T>,
HasPlus<T>,
HasMinus<T>,
HasMultiply<T>,
HasDivide<T>,
HasMap<T, UnaryOperator<BigDecimal>, ToBigDecimal<T>>,
HasMapToDouble<T, ToDoubleFunction<BigDecimal>>,
HasHash<T>,
HasCompare<T>,
HasCompose<T> {
    public static <T> ToBigDecimal<T> of(Function<T, BigDecimal> lambda) {
        if (lambda instanceof ToBigDecimal) {
            return (ToBigDecimal)lambda;
        }
        return lambda::apply;
    }

    @Override
    public BigDecimal apply(T var1);

    @Override
    default public ExpressionType expressionType() {
        return ExpressionType.BIG_DECIMAL;
    }

    @Override
    default public ToDouble<T> asDouble() {
        return CastUtil.castBigDecimalToDouble(this);
    }

    @Override
    default public ToInt<T> asInt() {
        return CastUtil.castBigDecimalToInt(this);
    }

    @Override
    default public ToLong<T> asLong() {
        return CastUtil.castBigDecimalToLong(this);
    }

    @Override
    default public ToBigDecimal<T> abs() {
        return AbsUtil.absBigDecimal(this);
    }

    @Override
    default public ToByte<T> sign() {
        return Expressions.sign(this);
    }

    @Override
    default public ToDouble<T> sqrt() {
        return this.asDouble().sqrt();
    }

    @Override
    default public ToBigDecimal<T> negate() {
        return Expressions.negate(this);
    }

    @Override
    default public ToDouble<T> pow(int power) {
        return Expressions.pow(this.asDouble(), power);
    }

    @Override
    default public ToDouble<T> pow(double power) {
        return Expressions.pow(this.asDouble(), power);
    }

    @Override
    default public ToDouble<T> pow(ToInt<T> power) {
        return Expressions.pow(this.asDouble(), power);
    }

    @Override
    default public ToDouble<T> pow(ToDouble<T> power) {
        return Expressions.pow(this.asDouble(), power);
    }

    @Override
    default public ToDouble<T> plus(byte other) {
        return Expressions.plus(this.asDouble(), (int)other);
    }

    @Override
    default public ToDouble<T> plus(ToByte<T> other) {
        return Expressions.plus(this.asDouble(), other.asInt());
    }

    @Override
    default public ToDouble<T> plus(int other) {
        return Expressions.plus(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> plus(ToInt<T> other) {
        return Expressions.plus(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> plus(long other) {
        return Expressions.plus(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> plus(ToLong<T> other) {
        return Expressions.plus(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> plus(double other) {
        return Expressions.plus(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> plus(ToDouble<T> other) {
        return Expressions.plus(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> minus(byte other) {
        return Expressions.minus(this.asDouble(), (int)other);
    }

    @Override
    default public ToDouble<T> minus(ToByte<T> other) {
        return Expressions.minus(this.asDouble(), other.asInt());
    }

    @Override
    default public ToDouble<T> minus(int other) {
        return Expressions.minus(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> minus(ToInt<T> other) {
        return Expressions.minus(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> minus(long other) {
        return Expressions.minus(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> minus(ToLong<T> other) {
        return Expressions.minus(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> minus(double other) {
        return Expressions.minus(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> minus(ToDouble<T> other) {
        return Expressions.minus(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> multiply(byte other) {
        return Expressions.multiply(this.asDouble(), (int)other);
    }

    @Override
    default public ToDouble<T> multiply(ToByte<T> other) {
        return Expressions.multiply(this.asDouble(), other.asInt());
    }

    @Override
    default public ToDouble<T> multiply(int other) {
        return Expressions.multiply(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> multiply(ToInt<T> other) {
        return Expressions.multiply(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> multiply(long other) {
        return Expressions.multiply(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> multiply(ToLong<T> other) {
        return Expressions.multiply(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> multiply(double other) {
        return Expressions.multiply(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> multiply(ToDouble<T> other) {
        return Expressions.multiply(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> divide(int divisor) {
        return Expressions.divide(this.asDouble(), divisor);
    }

    @Override
    default public ToDouble<T> divide(ToInt<T> divisor) {
        return Expressions.divide(this.asDouble(), divisor);
    }

    @Override
    default public ToDouble<T> divide(long divisor) {
        return Expressions.divide(this.asDouble(), divisor);
    }

    @Override
    default public ToDouble<T> divide(ToLong<T> divisor) {
        return Expressions.divide(this.asDouble(), divisor);
    }

    @Override
    default public ToDouble<T> divide(double divisor) {
        return Expressions.divide(this.asDouble(), divisor);
    }

    @Override
    default public ToDouble<T> divide(ToDouble<T> divisor) {
        return Expressions.divide(this.asDouble(), divisor);
    }

    @Override
    default public ToBigDecimal<T> map(UnaryOperator<BigDecimal> mapper) {
        return MapperUtil.mapBigDecimal(this, mapper);
    }

    @Override
    default public ToDouble<T> mapToDouble(ToDoubleFunction<BigDecimal> mapper) {
        return MapperUtil.mapBigDecimalToDouble(this, mapper);
    }

    @Override
    default public long hash(T object) {
        return ((BigDecimal)this.apply((Object)object)).hashCode();
    }

    @Override
    default public int compare(T first, T second) {
        return ((BigDecimal)this.apply((Object)first)).compareTo((BigDecimal)this.apply((Object)second));
    }

    @Override
    default public <V> ToBigDecimalNullable<V> compose(Function<? super V, ? extends T> before) {
        Function<? super V, ? extends T> casted = before;
        return ComposedUtil.composeToBigDecimal(casted, this);
    }
}

