/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.merger.standard.internal.query;

import com.speedment.jpastreamer.merger.QueryMerger;
import com.speedment.jpastreamer.merger.result.QueryMergeResult;
import com.speedment.jpastreamer.merger.standard.internal.query.result.InternalQueryMergeResult;
import com.speedment.jpastreamer.merger.standard.internal.query.strategy.QueryModifier;
import com.speedment.jpastreamer.merger.standard.internal.query.strategy.SkipLimitModifier;
import com.speedment.jpastreamer.merger.standard.internal.reference.IntermediateOperationReference;
import com.speedment.jpastreamer.merger.standard.internal.tracker.MergingTracker;
import com.speedment.jpastreamer.pipeline.Pipeline;
import com.speedment.jpastreamer.pipeline.intermediate.IntermediateOperation;
import com.speedment.jpastreamer.pipeline.intermediate.IntermediateOperationType;
import jakarta.persistence.Query;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;

public final class InternalQueryMerger
implements QueryMerger {
    private final Map<IntermediateOperationType, QueryModifier> mergingStrategies = new EnumMap<IntermediateOperationType, QueryModifier>(IntermediateOperationType.class);

    public InternalQueryMerger() {
        this.registerMergingStrategy(IntermediateOperationType.SKIP, SkipLimitModifier.INSTANCE);
        this.registerMergingStrategy(IntermediateOperationType.LIMIT, SkipLimitModifier.INSTANCE);
    }

    public <T> QueryMergeResult<T> merge(Pipeline<T> pipeline, Query query) {
        Objects.requireNonNull(pipeline);
        Objects.requireNonNull(query);
        MergingTracker mergingTracker = MergingTracker.createTracker();
        LinkedList intermediateOperations = pipeline.intermediateOperations();
        for (int i = 0; i < intermediateOperations.size(); ++i) {
            IntermediateOperation operation = (IntermediateOperation)intermediateOperations.get(i);
            IntermediateOperationType operationType = (IntermediateOperationType)operation.type();
            if (mergingTracker.mergedOperations().contains(operationType)) continue;
            QueryModifier queryModifier = this.mergingStrategies.get(operationType);
            if (queryModifier == null) break;
            IntermediateOperationReference operationReference = IntermediateOperationReference.createReference(operation, i, intermediateOperations);
            queryModifier.modifyQuery(operationReference, query, mergingTracker);
        }
        mergingTracker.forRemoval().stream().sorted(Comparator.reverseOrder()).forEach(idx -> intermediateOperations.remove((int)idx));
        return new InternalQueryMergeResult<T>(pipeline, query);
    }

    private void registerMergingStrategy(IntermediateOperationType operationType, QueryModifier queryModifier) {
        this.mergingStrategies.put(operationType, queryModifier);
    }
}

