/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.merger.standard.internal.criteria;

import com.speedment.jpastreamer.criteria.Criteria;
import com.speedment.jpastreamer.merger.CriteriaMerger;
import com.speedment.jpastreamer.merger.result.CriteriaMergeResult;
import com.speedment.jpastreamer.merger.standard.internal.criteria.result.InternalCriteriaMergeResult;
import com.speedment.jpastreamer.merger.standard.internal.criteria.strategy.CriteriaModifier;
import com.speedment.jpastreamer.merger.standard.internal.criteria.strategy.DistinctCriteriaModifier;
import com.speedment.jpastreamer.merger.standard.internal.criteria.strategy.FilterCriteriaModifier;
import com.speedment.jpastreamer.merger.standard.internal.criteria.strategy.SortedCriteriaModifier;
import com.speedment.jpastreamer.merger.standard.internal.reference.IntermediateOperationReference;
import com.speedment.jpastreamer.merger.standard.internal.tracker.MergingTracker;
import com.speedment.jpastreamer.pipeline.Pipeline;
import com.speedment.jpastreamer.pipeline.intermediate.IntermediateOperation;
import com.speedment.jpastreamer.pipeline.intermediate.IntermediateOperationType;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;

public final class InternalCriteriaMerger
implements CriteriaMerger {
    private final Map<IntermediateOperationType, CriteriaModifier> mergingStrategies = new EnumMap<IntermediateOperationType, CriteriaModifier>(IntermediateOperationType.class);

    public InternalCriteriaMerger() {
        this.registerMergingStrategy(IntermediateOperationType.FILTER, FilterCriteriaModifier.INSTANCE);
        this.registerMergingStrategy(IntermediateOperationType.DISTINCT, DistinctCriteriaModifier.INSTANCE);
        this.registerMergingStrategy(IntermediateOperationType.SORTED, SortedCriteriaModifier.INSTANCE);
    }

    public <ENTITY> CriteriaMergeResult<ENTITY> merge(Pipeline<ENTITY> pipeline, Criteria<ENTITY, ?> criteria) {
        Objects.requireNonNull(pipeline);
        Objects.requireNonNull(criteria);
        MergingTracker mergingTracker = MergingTracker.createTracker();
        LinkedList intermediateOperations = pipeline.intermediateOperations();
        for (int i = 0; i < intermediateOperations.size(); ++i) {
            IntermediateOperation operation = (IntermediateOperation)intermediateOperations.get(i);
            IntermediateOperationType operationType = (IntermediateOperationType)operation.type();
            if (mergingTracker.mergedOperations().contains(operationType)) continue;
            CriteriaModifier criteriaModifier = this.mergingStrategies.get(operationType);
            if (criteriaModifier != null) {
                IntermediateOperationReference operationReference = IntermediateOperationReference.createReference(operation, i, intermediateOperations);
                criteriaModifier.modifyCriteria(operationReference, criteria, mergingTracker);
            }
            if (!mergingTracker.mergedOperations().contains(operationType)) break;
        }
        mergingTracker.forRemoval().stream().sorted(Comparator.reverseOrder()).forEach(idx -> intermediateOperations.remove((int)idx));
        return new InternalCriteriaMergeResult<ENTITY>(pipeline, criteria);
    }

    private void registerMergingStrategy(IntermediateOperationType operationType, CriteriaModifier criteriaModifier) {
        this.mergingStrategies.put(operationType, criteriaModifier);
    }
}

