/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.analytics.standard.internal.google;

import com.speedment.jpastreamer.analytics.standard.internal.google.InternalAnalyticsException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

final class HttpUtil {
    private static final int DEFAULT_TIME_OUT_MS = 2000;
    private static final String THREAD_NAME = "chronicle~analytics~http~client";
    private static final Executor EXECUTOR = Executors.newSingleThreadExecutor(runnable -> {
        Thread thread = new Thread(runnable, THREAD_NAME);
        thread.setDaemon(true);
        return thread;
    });

    private HttpUtil() {
    }

    public static void send(String urlString, String body) {
        Objects.requireNonNull(urlString);
        Objects.requireNonNull(body);
        EXECUTOR.execute(new Sender(urlString, body));
    }

    static String urlEncode(String s) {
        Objects.requireNonNull(s);
        try {
            return URLEncoder.encode(s, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Exception while URL encoding statistics for Google Analytics.");
            e.printStackTrace();
            throw new InternalAnalyticsException("This should never happen as " + String.valueOf(StandardCharsets.UTF_8) + " should always be present.");
        }
    }

    static final class Sender
    implements Runnable {
        private final String urlString;
        private final String body;

        Sender(String urlString, String body) {
            Objects.requireNonNull(urlString);
            Objects.requireNonNull(body);
            this.urlString = urlString;
            this.body = body;
        }

        @Override
        public void run() {
            try {
                URL url = new URL(this.urlString);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setConnectTimeout(2000);
                conn.setReadTimeout(2000);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "text/plain; charset=UTF-8");
                conn.setRequestProperty("t", "application/json");
                conn.setDoOutput(true);
                try (OutputStream os = conn.getOutputStream();){
                    byte[] output = this.body.getBytes(StandardCharsets.UTF_8);
                    os.write(output, 0, output.length);
                    os.flush();
                }
                try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                    String responseLine;
                    StringBuilder response = new StringBuilder();
                    String sep = "";
                    while ((responseLine = br.readLine()) != null) {
                        response.append(sep).append(responseLine);
                        sep = " ";
                    }
                    String logMsg = response.toString().replaceAll("\\s+(?=\\S)", " ");
                    if (!logMsg.isEmpty()) {
                        System.out.println(logMsg);
                    }
                }
            }
            catch (IOException ioe) {
                System.err.println("Exception while sending usage statistics to Google Analytics.");
                ioe.printStackTrace();
            }
        }
    }
}

