/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.controller;

import com.speedment.common.codegen.constant.SimpleParameterizedType;
import com.speedment.common.codegen.constant.SimpleType;
import com.speedment.common.codegen.model.Class;
import com.speedment.common.codegen.model.Field;
import com.speedment.common.codegen.model.File;
import com.speedment.common.codegen.model.Generic;
import com.speedment.common.codegen.model.Javadoc;
import com.speedment.common.codegen.model.JavadocTag;
import com.speedment.common.codegen.model.Method;
import com.speedment.common.codegen.util.Formatting;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Consumer;

public final class SetGetAdd
implements Consumer<File> {
    private static final String RETURN = "return";
    private static final String THIS = "this";
    public static final String OF_THIS = " of this ";
    private final BiPredicate<Field, Method> onlyInclude;

    public SetGetAdd() {
        this.onlyInclude = (f, m) -> true;
    }

    public SetGetAdd(BiPredicate<Field, Method> onlyInclude) {
        this.onlyInclude = Objects.requireNonNull(onlyInclude);
    }

    @Override
    public void accept(File file) {
        Objects.requireNonNull(file);
        file.getClasses().stream().filter(Class.class::isInstance).map(Class.class::cast).forEach(c -> this.accept(file, (Class)c));
    }

    private void accept(File file, Class model) {
        Objects.requireNonNull(model);
        Type self = model.getGenerics().isEmpty() ? SimpleType.create(model.getName()) : SimpleParameterizedType.create(model.getName(), (Type[])model.getGenerics().stream().map(Generic::asType).toArray(Type[]::new));
        model.getFields().forEach(f -> {
            f.private_();
            if (this.isCollection(f.getType())) {
                this.generateAdder(model, self, (Field)f);
            } else {
                this.generateSetter(model, self, (Field)f);
            }
            Method get = (Method)((Method)((Method)Method.of("get" + Formatting.ucfirst(f.getName()), f.getType()).set((Javadoc)Javadoc.of().setText("Gets the " + f.getName() + OF_THIS + Formatting.shortName(model.getName()) + ".").add(JavadocTag.of(RETURN, "the " + f.getName())))).public_()).add("return this." + f.getName() + ";");
            if (this.onlyInclude.test((Field)f, get)) {
                model.add(get);
            }
        });
        model.getClasses().stream().filter(Class.class::isInstance).map(Class.class::cast).forEach(c -> this.accept(file, (Class)c));
    }

    private void generateSetter(Class model, Type self, Field f) {
        Method set = (Method)((Method)Method.of("set" + Formatting.ucfirst(f.getName()), self).set((Javadoc)((Javadoc)Javadoc.of().setText("Sets the " + f.getName() + OF_THIS + Formatting.shortName(model.getName()) + ".").add(JavadocTag.of("param", f.getName(), "the new value"))).add(JavadocTag.of(RETURN, "a reference to this object")))).public_();
        if (this.isOptional(f.getType())) {
            ParameterizedType paramType = (ParameterizedType)f.getType();
            ((Method)((Method)set.add(Field.of(f.getName(), paramType.getActualTypeArguments()[0]))).add("this." + f.getName() + " = Optional.of(" + f.getName() + ");")).add("return this;");
        } else {
            ((Method)((Method)set.add(Field.of(f.getName(), f.getType()))).add("this." + f.getName() + " = " + f.getName() + ";")).add("return this;");
        }
        if (this.onlyInclude.test(f, set)) {
            model.add(set);
        }
    }

    private void generateAdder(Class model, Type self, Field f) {
        f.final_();
        ParameterizedType paramType = (ParameterizedType)f.getType();
        Field param = Field.of(this.singular(f.getName()), paramType.getActualTypeArguments()[0]);
        Method add = (Method)((Method)((Method)((Method)((Method)Method.of("addTo" + Formatting.ucfirst(f.getName()), self).set((Javadoc)((Javadoc)Javadoc.of().setText("Adds the specified " + Formatting.lcfirst(Formatting.shortName(param.getType().getTypeName())) + " to the " + f.getName() + OF_THIS + Formatting.shortName(model.getName()) + ".").add(JavadocTag.of("param", param.getName(), "the new value"))).add(JavadocTag.of(RETURN, "a reference to this object")))).public_()).add(param)).add("this." + f.getName() + ".add(" + param.getName() + ");")).add("return this;");
        if (this.onlyInclude.test(f, add)) {
            model.add(add);
        }
    }

    private boolean isCollection(Type type) {
        try {
            java.lang.Class<?> clazz = java.lang.Class.forName(type.getTypeName());
            return Collection.class.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean isOptional(Type type) {
        return type.getTypeName().startsWith("java.lang.Optional");
    }

    private String singular(String word) {
        if (Objects.requireNonNull(word).endsWith("ies")) {
            return word.substring(0, word.length() - 3) + "y";
        }
        if (word.endsWith("s")) {
            return word.substring(0, word.length() - 1);
        }
        return word;
    }
}

