/*
 * Decompiled with CFR 0.152.
 */
package spark.embeddedserver.jetty;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.embeddedserver.EmbeddedServer;
import spark.embeddedserver.jetty.JettyServer;
import spark.embeddedserver.jetty.SocketConnectorFactory;
import spark.embeddedserver.jetty.websocket.WebSocketServletContextHandlerFactory;
import spark.ssl.SslStores;

public class EmbeddedJettyServer
implements EmbeddedServer {
    private static final int SPARK_DEFAULT_PORT = 4567;
    private static final String NAME = "Spark";
    private Handler handler;
    private Server server;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, Class<?>> webSocketHandlers;
    private Optional<Integer> webSocketIdleTimeoutMillis;

    public EmbeddedJettyServer(Handler handler) {
        this.handler = handler;
    }

    @Override
    public void configureWebSockets(Map<String, Class<?>> webSocketHandlers, Optional<Integer> webSocketIdleTimeoutMillis) {
        this.webSocketHandlers = webSocketHandlers;
        this.webSocketIdleTimeoutMillis = webSocketIdleTimeoutMillis;
    }

    @Override
    public void ignite(String host, int port, SslStores sslStores, CountDownLatch latch, int maxThreads, int minThreads, int threadIdleTimeoutMillis) {
        if (port == 0) {
            try (ServerSocket s = new ServerSocket(0);){
                port = s.getLocalPort();
            }
            catch (IOException e) {
                this.logger.error("Could not get first available port (port set to 0), using default: {}", (Object)4567);
                port = 4567;
            }
        }
        this.server = JettyServer.create(maxThreads, minThreads, threadIdleTimeoutMillis);
        ServerConnector connector = sslStores == null ? SocketConnectorFactory.createSocketConnector(this.server, host, port) : SocketConnectorFactory.createSecureSocketConnector(this.server, host, port, sslStores);
        this.server = connector.getServer();
        this.server.setConnectors(new Connector[]{connector});
        ServletContextHandler webSocketServletContextHandler = WebSocketServletContextHandlerFactory.create(this.webSocketHandlers, this.webSocketIdleTimeoutMillis);
        if (webSocketServletContextHandler == null) {
            this.server.setHandler(this.handler);
        } else {
            ArrayList<Object> handlersInList = new ArrayList<Object>();
            handlersInList.add(this.handler);
            if (webSocketServletContextHandler != null) {
                handlersInList.add(webSocketServletContextHandler);
            }
            HandlerList handlers = new HandlerList();
            handlers.setHandlers(handlersInList.toArray(new Handler[handlersInList.size()]));
            this.server.setHandler((Handler)handlers);
        }
        try {
            this.logger.info("== {} has ignited ...", (Object)NAME);
            this.logger.info(">> Listening on {}:{}", (Object)host, (Object)port);
            this.server.start();
            latch.countDown();
            this.server.join();
        }
        catch (Exception e) {
            this.logger.error("ignite failed", (Throwable)e);
            System.exit(100);
        }
    }

    @Override
    public void extinguish() {
        this.logger.info(">>> {} shutting down ...", (Object)NAME);
        try {
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (Exception e) {
            this.logger.error("stop failed", (Throwable)e);
            System.exit(100);
        }
        this.logger.info("done");
    }
}

