/*
 * Decompiled with CFR 0.152.
 */
package com.soundcloud.android.crop;

import android.app.ProgressDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Handler;
import android.os.ParcelFileDescriptor;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.soundcloud.android.crop.Log;
import com.soundcloud.android.crop.MonitoredActivity;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

class CropUtil {
    private static final String SCHEME_FILE = "file";
    private static final String SCHEME_CONTENT = "content";

    CropUtil() {
    }

    public static void closeSilently(@Nullable Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static int getExifRotation(File imageFile) {
        if (imageFile == null) {
            return 0;
        }
        try {
            ExifInterface exif = new ExifInterface(imageFile.getAbsolutePath());
            switch (exif.getAttributeInt("Orientation", 0)) {
                case 6: {
                    return 90;
                }
                case 3: {
                    return 180;
                }
                case 8: {
                    return 270;
                }
            }
            return 0;
        }
        catch (IOException e) {
            Log.e("Error getting Exif data", e);
            return 0;
        }
    }

    public static boolean copyExifRotation(File sourceFile, File destFile) {
        if (sourceFile == null || destFile == null) {
            return false;
        }
        try {
            ExifInterface exifSource = new ExifInterface(sourceFile.getAbsolutePath());
            ExifInterface exifDest = new ExifInterface(destFile.getAbsolutePath());
            exifDest.setAttribute("Orientation", exifSource.getAttribute("Orientation"));
            exifDest.saveAttributes();
            return true;
        }
        catch (IOException e) {
            Log.e("Error copying Exif data", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static File getFromMediaUri(Context context, ContentResolver resolver, Uri uri) {
        if (uri == null) {
            return null;
        }
        if (SCHEME_FILE.equals(uri.getScheme())) {
            return new File(uri.getPath());
        }
        if (SCHEME_CONTENT.equals(uri.getScheme())) {
            String[] filePathColumn = new String[]{"_data", "_display_name"};
            try (Cursor cursor = null;){
                cursor = resolver.query(uri, filePathColumn, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    String filePath;
                    int columnIndex;
                    int n = columnIndex = uri.toString().startsWith("content://com.google.android.gallery3d") ? cursor.getColumnIndex("_display_name") : cursor.getColumnIndex("_data");
                    if (columnIndex != -1 && !TextUtils.isEmpty((CharSequence)(filePath = cursor.getString(columnIndex)))) {
                        File file = new File(filePath);
                        return file;
                    }
                }
            }
        }
        return null;
    }

    private static String getTempFilename(Context context) throws IOException {
        File outputDir = context.getCacheDir();
        File outputFile = File.createTempFile("image", "tmp", outputDir);
        return outputFile.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    @Nullable
    private static File getFromMediaUriPfd(Context context, ContentResolver resolver, Uri uri) {
        File file;
        if (uri == null) {
            return null;
        }
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            int read;
            ParcelFileDescriptor pfd = resolver.openFileDescriptor(uri, "r");
            FileDescriptor fd = pfd.getFileDescriptor();
            input = new FileInputStream(fd);
            String tempFilename = CropUtil.getTempFilename(context);
            output = new FileOutputStream(tempFilename);
            byte[] bytes = new byte[4096];
            while ((read = input.read(bytes)) != -1) {
                output.write(bytes, 0, read);
            }
            file = new File(tempFilename);
        }
        catch (IOException iOException) {
            CropUtil.closeSilently(input);
            CropUtil.closeSilently(output);
            catch (Throwable throwable) {
                CropUtil.closeSilently(input);
                CropUtil.closeSilently(output);
                throw throwable;
            }
        }
        CropUtil.closeSilently(input);
        CropUtil.closeSilently(output);
        return file;
        return null;
    }

    public static void startBackgroundJob(MonitoredActivity activity, String title, String message, Runnable job, Handler handler) {
        ProgressDialog dialog = ProgressDialog.show((Context)activity, (CharSequence)title, (CharSequence)message, (boolean)true, (boolean)false);
        new Thread(new BackgroundJob(activity, job, dialog, handler)).start();
    }

    private static class BackgroundJob
    extends MonitoredActivity.LifeCycleAdapter
    implements Runnable {
        private final MonitoredActivity activity;
        private final ProgressDialog dialog;
        private final Runnable job;
        private final Handler handler;
        private final Runnable cleanupRunner = new Runnable(){

            @Override
            public void run() {
                BackgroundJob.this.activity.removeLifeCycleListener(BackgroundJob.this);
                if (BackgroundJob.this.dialog.getWindow() != null) {
                    BackgroundJob.this.dialog.dismiss();
                }
            }
        };

        public BackgroundJob(MonitoredActivity activity, Runnable job, ProgressDialog dialog, Handler handler) {
            this.activity = activity;
            this.dialog = dialog;
            this.job = job;
            this.activity.addLifeCycleListener(this);
            this.handler = handler;
        }

        @Override
        public void run() {
            try {
                this.job.run();
            }
            finally {
                this.handler.post(this.cleanupRunner);
            }
        }

        @Override
        public void onActivityDestroyed(MonitoredActivity activity) {
            this.cleanupRunner.run();
            this.handler.removeCallbacks(this.cleanupRunner);
        }

        @Override
        public void onActivityStopped(MonitoredActivity activity) {
            this.dialog.hide();
        }

        @Override
        public void onActivityStarted(MonitoredActivity activity) {
            this.dialog.show();
        }
    }
}

