/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.maven.plugins.iterator;

import com.soebes.maven.plugins.iterator.AbstractIteratorMojo;
import com.soebes.maven.plugins.iterator.ItemWithProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.InvocationRequest;

public abstract class AbstractInvokerMojo
extends AbstractIteratorMojo {
    @Parameter
    private List<String> goals = Collections.singletonList("clean");
    @Parameter(defaultValue="false")
    private boolean interactive;
    @Parameter(defaultValue="false")
    private boolean alsoMake;
    @Parameter(defaultValue="false")
    private boolean alsoMakeDependents;
    @Parameter
    private File baseDirectory;
    @Parameter(defaultValue="false")
    private boolean debug;
    @Parameter(defaultValue="fail-fast")
    private String failureBehaviour;
    @Parameter(defaultValue="warn")
    private String globalChecksumPolicy;
    @Parameter
    private File globalSettingsFile;
    @Parameter
    private File localRepositoryDirectory;
    @Parameter
    private String mavenOpts;
    @Parameter
    private boolean nonPluginUpdates;
    @Parameter
    private boolean offline;
    @Parameter
    private List<String> profiles;
    @Parameter
    private List<String> projects;
    @Parameter
    private Properties properties;
    @Parameter(defaultValue="false")
    private boolean recursive;
    @Parameter
    private String resumeFrom;
    @Parameter(defaultValue="true")
    private boolean shellEnvironmentInherited;
    @Parameter(defaultValue="false")
    private boolean showErrors;
    @Parameter(defaultValue="false")
    private boolean showVersion;
    @Parameter
    protected String threads;
    @Parameter
    private File toolchains;
    @Parameter(defaultValue="false")
    private boolean updateSnapshots;
    @Parameter
    private File userSettings;

    private File getBaseDirectoryAfterPlaceHolderIsReplaced(String currentValue) {
        File baseDir = this.getBaseDirectory();
        if (baseDir != null && baseDir.toString().contains(this.getPlaceHolder())) {
            baseDir = new File(baseDir.toString().replaceAll(this.getPlaceHolder(), currentValue));
        }
        return baseDir;
    }

    private List<String> replacePlaceholderInElements(String currentValue, List<String> goals) {
        ArrayList<String> result = new ArrayList<String>();
        for (String string : goals) {
            if (string.contains(this.getPlaceHolder())) {
                result.add(string.replaceAll(this.getPlaceHolder(), currentValue));
                continue;
            }
            result.add(string);
        }
        return result;
    }

    private List<String> getGoalsAfterPlaceHolderIsReplaced(String currentValue) {
        List<String> goals = this.getGoals();
        if (goals == null) {
            return null;
        }
        List<String> result = this.replacePlaceholderInElements(currentValue, goals);
        return result;
    }

    private List<String> getProfilesAfterPlaceHolderIsReplaced(String currentValue) {
        List<String> profiles = this.getProfiles();
        if (profiles == null) {
            return null;
        }
        List<String> result = this.replacePlaceholderInElements(currentValue, profiles);
        return result;
    }

    private List<String> getProjectsAfterPlaceHolderIsReplaced(String currentValue) {
        List<String> projects = this.getProjects();
        if (projects == null) {
            return null;
        }
        List<String> result = this.replacePlaceholderInElements(currentValue, projects);
        return result;
    }

    protected InvocationRequest createAndConfigureAnInvocationRequest(ItemWithProperties currentValue) {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setAlsoMake(this.isAlsoMake());
        request.setAlsoMakeDependents(this.isAlsoMakeDependents());
        request.setDebug(this.isDebug());
        request.setFailureBehavior(this.getFailureBehaviour());
        request.setGlobalChecksumPolicy(this.getGlobalChecksumPolicy());
        request.setGlobalSettingsFile(this.getGlobalSettingsFile());
        request.setInteractive(this.isInteractive());
        request.setLocalRepositoryDirectory(this.getLocalRepositoryDirectory());
        request.setMavenOpts(this.getMavenOpts());
        request.setNonPluginUpdates(this.isNonPluginUpdates());
        request.setOffline(this.isOffline());
        request.setBaseDirectory(this.getBaseDirectoryAfterPlaceHolderIsReplaced(currentValue.getName()));
        request.setGoals(this.getGoalsAfterPlaceHolderIsReplaced(currentValue.getName()));
        request.setProfiles(this.getProfilesAfterPlaceHolderIsReplaced(currentValue.getName()));
        request.setProjects(this.getProjectsAfterPlaceHolderIsReplaced(currentValue.getName()));
        Properties props = this.getMergedProperties(currentValue);
        request.setProperties(props);
        request.setRecursive(this.isRecursive());
        request.setResumeFrom(this.getResumeFrom());
        request.setShellEnvironmentInherited(this.isShellEnvironmentInherited());
        request.setShowErrors(this.isShowErrors());
        request.setShowVersion(this.isShowVersion());
        request.setThreads(this.getThreads());
        request.setToolchainsFile(this.getToolchains());
        request.setUpdateSnapshots(this.isUpdateSnapshots());
        request.setUserSettingsFile(this.getUserSettings());
        return request;
    }

    private Properties getMergedProperties(ItemWithProperties item) {
        Properties props = new Properties();
        if (this.getMavenProject().getProperties() != null) {
            props.putAll((Map<?, ?>)this.getMavenProject().getProperties());
        }
        if (this.getProperties() != null) {
            props.putAll((Map<?, ?>)this.getProperties());
        }
        if (item.getProperties() != null) {
            props.putAll((Map<?, ?>)item.getProperties());
        }
        for (Map.Entry<Object, Object> property : props.entrySet()) {
            String key = (String)property.getKey();
            String systemPropertyValue = System.getProperty(key);
            if (systemPropertyValue == null) continue;
            props.put(key, systemPropertyValue);
        }
        return props;
    }

    public List<String> getGoals() {
        return this.goals;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public boolean isAlsoMake() {
        return this.alsoMake;
    }

    public void setAlsoMake(boolean alsoMake) {
        this.alsoMake = alsoMake;
    }

    public boolean isAlsoMakeDependents() {
        return this.alsoMakeDependents;
    }

    public void setAlsoMakeDependents(boolean alsoMakeDependents) {
        this.alsoMakeDependents = alsoMakeDependents;
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getFailureBehaviour() {
        return this.failureBehaviour;
    }

    public void setFailureBehaviour(String failureBehaviour) {
        this.failureBehaviour = failureBehaviour;
    }

    public String getGlobalChecksumPolicy() {
        return this.globalChecksumPolicy;
    }

    public void setGlobalChecksumPolicy(String globalChecksumPolicy) {
        this.globalChecksumPolicy = globalChecksumPolicy;
    }

    public File getGlobalSettingsFile() {
        return this.globalSettingsFile;
    }

    public void setGlobalSettingsFile(File globalSettingsFile) {
        this.globalSettingsFile = globalSettingsFile;
    }

    public File getLocalRepositoryDirectory() {
        return this.localRepositoryDirectory;
    }

    public void setLocalRepositoryDirectory(File localRepositoryDirectory) {
        this.localRepositoryDirectory = localRepositoryDirectory;
    }

    public String getMavenOpts() {
        return this.mavenOpts;
    }

    public void setMavenOpts(String mavenOpts) {
        this.mavenOpts = mavenOpts;
    }

    public boolean isNonPluginUpdates() {
        return this.nonPluginUpdates;
    }

    public void setNonPluginUpdates(boolean nonPluginUpdates) {
        this.nonPluginUpdates = nonPluginUpdates;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public List<String> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(List<String> profiles) {
        this.profiles = profiles;
    }

    public List<String> getProjects() {
        return this.projects;
    }

    public void setProjects(List<String> projects) {
        this.projects = projects;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public String getResumeFrom() {
        return this.resumeFrom;
    }

    public void setResumeFrom(String resumeFrom) {
        this.resumeFrom = resumeFrom;
    }

    public boolean isShellEnvironmentInherited() {
        return this.shellEnvironmentInherited;
    }

    public void setShellEnvironmentInherited(boolean shellEnvironmentInherited) {
        this.shellEnvironmentInherited = shellEnvironmentInherited;
    }

    public boolean isShowErrors() {
        return this.showErrors;
    }

    public void setShowErrors(boolean showErrors) {
        this.showErrors = showErrors;
    }

    public boolean isShowVersion() {
        return this.showVersion;
    }

    public void setShowVersion(boolean showVersion) {
        this.showVersion = showVersion;
    }

    public String getThreads() {
        return this.threads;
    }

    public File getToolchains() {
        return this.toolchains;
    }

    public void setToolchains(File toolchains) {
        this.toolchains = toolchains;
    }

    public boolean isUpdateSnapshots() {
        return this.updateSnapshots;
    }

    public void setUpdateSnapshots(boolean updateSnapshots) {
        this.updateSnapshots = updateSnapshots;
    }

    public File getUserSettings() {
        return this.userSettings;
    }

    public void setUserSettings(File userSettings) {
        this.userSettings = userSettings;
    }

    public void setGoals(List<String> goals) {
        this.goals = goals;
    }
}

