/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.maven.plugins.itexin;

import com.soebes.maven.plugins.itexin.AbstractIteratorMojo;
import com.soebes.maven.plugins.itexin.PluginExecutor;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;
import org.twdata.maven.mojoexecutor.PlexusConfigurationUtils;

@Mojo(name="executor", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true)
public class ExecutorMojo
extends AbstractIteratorMojo {
    @Parameter(required=true)
    private List<PluginExecutor> pluginExecutors;
    @Parameter(required=true, readonly=true, defaultValue="${project}")
    private MavenProject mavenProject;
    @Parameter(required=true, readonly=true, defaultValue="${session}")
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;
    @Component
    private PluginDescriptor pluginDescriptor;

    private PlexusConfiguration copyConfiguration(PlexusConfiguration src, String iteratorName, String value) {
        XmlPlexusConfiguration dom = new XmlPlexusConfiguration(src.getName());
        if (src.getValue() != null) {
            if (src.getValue().contains(iteratorName)) {
                dom.setValue(src.getValue().replaceAll(iteratorName, value));
            } else {
                dom.setValue(src.getValue());
            }
        } else {
            dom.setValue(src.getValue(null));
        }
        for (String string : src.getAttributeNames()) {
            dom.setAttribute(string, src.getAttribute(string, null));
        }
        for (String string : src.getChildren()) {
            dom.addChild(this.copyConfiguration((PlexusConfiguration)string, iteratorName, value));
        }
        return dom;
    }

    private Plugin getPluginVersionFromPluginManagement(Plugin plugin) {
        if (!this.isPluginManagementDefined()) {
            return plugin;
        }
        if (this.isPluginVersionDefined(plugin)) {
            return plugin;
        }
        Map plugins = this.mavenProject.getPluginManagement().getPluginsAsMap();
        Plugin result = (Plugin)plugins.get(plugin.getKey());
        if (result == null) {
            return plugin;
        }
        return result;
    }

    private boolean isPluginVersionDefined(Plugin plugin) {
        return plugin.getVersion() != null;
    }

    private boolean isPluginManagementDefined() {
        return this.mavenProject.getPluginManagement() != null;
    }

    public void execute() throws MojoExecutionException {
        if (this.isItemsNull() && this.isContentNull()) {
            throw new MojoExecutionException("You have to use at least one. Either items element or content element!");
        }
        if (this.isItemsSet() && this.isContentSet()) {
            throw new MojoExecutionException("You can use only one element. Either items element or content element but not both!");
        }
        for (String item : this.getItems()) {
            for (PluginExecutor pluginExecutor : this.pluginExecutors) {
                Plugin executePlugin = this.getPluginVersionFromPluginManagement(pluginExecutor.getPlugin());
                if (executePlugin.getVersion() == null) {
                    throw new MojoExecutionException("Unknown plugin version. You have to define the version either directly or via pluginManagement.");
                }
                this.getLog().debug((CharSequence)("Configuration(before): " + pluginExecutor.getConfiguration().toString()));
                PlexusConfiguration plexusConfiguration = this.copyConfiguration((PlexusConfiguration)pluginExecutor.getConfiguration(), this.getPlaceHolder(), item);
                this.getLog().debug((CharSequence)("plexusConfiguration(after): " + plexusConfiguration.toString()));
                this.createLogOutput(pluginExecutor, executePlugin);
                this.mavenProject.getProperties().put(this.getIteratorName(), item);
                MojoExecutor.executeMojo((Plugin)executePlugin, (String)pluginExecutor.getGoal(), (Xpp3Dom)PlexusConfigurationUtils.toXpp3Dom((PlexusConfiguration)plexusConfiguration), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
            }
        }
    }

    private void createLogOutput(PluginExecutor pluginExecutor, Plugin executePlugin) {
        StringBuilder sb = new StringBuilder("------ ");
        sb.append(executePlugin.getKey());
        sb.append(":");
        sb.append(executePlugin.getVersion());
        sb.append(":");
        sb.append(pluginExecutor.getGoal());
        this.getLog().info((CharSequence)sb.toString());
    }

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public void setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    public MavenSession getMavenSession() {
        return this.mavenSession;
    }

    public void setMavenSession(MavenSession mavenSession) {
        this.mavenSession = mavenSession;
    }
}

