/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.plugin.credential.browser.keyring;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.singlestore.jdbc.plugin.credential.browser.ExpiringCredential;
import com.singlestore.jdbc.plugin.credential.browser.keyring.LinuxKeyring;
import com.singlestore.jdbc.plugin.credential.browser.keyring.MacKeyring;
import com.singlestore.jdbc.plugin.credential.browser.keyring.WindowsKeyring;
import com.singlestore.jdbc.util.log.Logger;
import com.singlestore.jdbc.util.log.Loggers;
import java.io.IOException;

public interface Keyring {
    public static final String STORAGE_KEY = "SingleStore JDBC Safe Storage";
    public static final Logger logger = Loggers.getLogger(Keyring.class);

    public ExpiringCredential getCredential();

    public void setCredential(ExpiringCredential var1);

    public static String makeBlob(ExpiringCredential cred) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        try {
            String credJson = mapper.writeValueAsString((Object)cred);
            return credJson;
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static ExpiringCredential fromBlob(String blob) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        return (ExpiringCredential)mapper.readValue(blob, ExpiringCredential.class);
    }

    public static Keyring buildForCurrentOS() {
        String operSys = System.getProperty("os.name").toLowerCase();
        try {
            if (operSys.contains("win")) {
                return new WindowsKeyring();
            }
            if (operSys.contains("nix") || operSys.contains("nux") || operSys.contains("aix")) {
                return new LinuxKeyring();
            }
            if (operSys.contains("mac")) {
                return new MacKeyring();
            }
        }
        catch (Exception e) {
            logger.warn("Could not connect to a " + System.getProperty("os.name") + " OS keyring. Credentials will not be persisted between sessions.", e);
        }
        return null;
    }

    public void deleteCredential();
}

