/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.client;

import com.singlestore.jdbc.Configuration;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SocketHelper {
    public static void setSocketOption(Configuration conf, Socket socket) throws IOException {
        socket.setTcpNoDelay(true);
        socket.setSoTimeout(conf.socketTimeout());
        if (conf.tcpKeepAlive()) {
            socket.setKeepAlive(true);
        }
        if (conf.tcpAbortiveClose()) {
            socket.setSoLinger(true, 0);
        }
        if (conf.localSocketAddress() != null) {
            InetSocketAddress localAddress = new InetSocketAddress(conf.localSocketAddress(), 0);
            socket.bind(localAddress);
        }
    }
}

