/*
 * Decompiled with CFR 0.152.
 */
package com.simprints.libsimprints;

import android.content.Intent;
import android.support.annotation.NonNull;
import com.simprints.libsimprints.Metadata;

public class SimHelper {
    private final String apiKey;
    private final String userId;

    public SimHelper(@NonNull String apiKey, @NonNull String userId) {
        this.apiKey = apiKey;
        this.userId = userId;
    }

    @NonNull
    public Intent register(@NonNull String moduleId) {
        return new Intent("com.simprints.id.REGISTER").putExtra("apiKey", this.apiKey).putExtra("userId", this.userId).putExtra("moduleId", moduleId);
    }

    @NonNull
    public Intent register(@NonNull String moduleId, @NonNull Metadata metadata) {
        return this.register(moduleId).putExtra("metadata", metadata.toString());
    }

    @NonNull
    public Intent update(@NonNull String moduleId, @NonNull String updateId) {
        return new Intent("com.simprints.id.UPDATE").putExtra("apiKey", this.apiKey).putExtra("userId", this.userId).putExtra("moduleId", moduleId).putExtra("updateGuid", updateId);
    }

    @NonNull
    public Intent update(@NonNull String moduleId, @NonNull String updateId, @NonNull Metadata metadata) {
        return this.update(moduleId, updateId).putExtra("metadata", metadata.toString());
    }

    @NonNull
    public Intent identify(@NonNull String moduleId) {
        Intent intent = new Intent("com.simprints.id.IDENTIFY");
        intent.putExtra("apiKey", this.apiKey);
        intent.putExtra("userId", this.userId);
        intent.putExtra("moduleId", moduleId);
        return intent;
    }

    @NonNull
    public Intent identify(@NonNull String moduleId, @NonNull Metadata metadata) {
        return this.identify(moduleId).putExtra("metadata", metadata.toString());
    }

    @NonNull
    public Intent verify(@NonNull String moduleId, @NonNull String verifyId) {
        Intent intent = new Intent("com.simprints.id.VERIFY");
        intent.putExtra("apiKey", this.apiKey);
        intent.putExtra("userId", this.userId);
        intent.putExtra("moduleId", moduleId);
        intent.putExtra("verifyGuid", verifyId);
        return intent;
    }

    @NonNull
    public Intent verify(@NonNull String moduleId, @NonNull String verifyId, @NonNull Metadata metadata) {
        return this.verify(moduleId, verifyId).putExtra("metadata", metadata.toString());
    }
}

