/*
 * Decompiled with CFR 0.152.
 */
package com.simprints.libsimprints;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.simprints.libsimprints.FingerIdentifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Registration
implements Parcelable {
    private String guid;
    private Map<FingerIdentifier, byte[]> templates;
    public static final Parcelable.Creator<Registration> CREATOR = new Parcelable.Creator<Registration>(){

        public Registration createFromParcel(Parcel in) {
            return new Registration(in);
        }

        public Registration[] newArray(int size) {
            return new Registration[size];
        }
    };

    public Registration(String guid) {
        this.guid = guid;
        this.templates = new HashMap<FingerIdentifier, byte[]>();
    }

    protected Registration(Parcel in) {
        this.guid = in.readString();
        int nbOfTemplates = in.readInt();
        this.templates = new HashMap<FingerIdentifier, byte[]>(nbOfTemplates);
        for (int i = 0; i < nbOfTemplates; ++i) {
            FingerIdentifier fingerId = FingerIdentifier.values()[in.readInt()];
            byte[] fingerTemplate = new byte[in.readInt()];
            in.readByteArray(fingerTemplate);
            this.templates.put(fingerId, fingerTemplate);
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.guid);
        dest.writeInt(this.templates.size());
        for (Map.Entry<FingerIdentifier, byte[]> e : this.templates.entrySet()) {
            dest.writeInt(e.getKey().ordinal());
            dest.writeInt(e.getValue().length);
            dest.writeByteArray(e.getValue());
        }
    }

    public String getGuid() {
        return this.guid;
    }

    public void setTemplate(FingerIdentifier fingerId, @NonNull byte[] fingerTemplate) {
        this.templates.put(fingerId, fingerTemplate);
    }

    public byte[] getTemplate(FingerIdentifier fingerId) {
        if (this.templates.containsKey((Object)fingerId)) {
            return this.templates.get((Object)fingerId);
        }
        return new byte[0];
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Registration)) {
            return false;
        }
        Registration other = (Registration)o;
        if (!this.guid.equals(other.guid)) {
            return false;
        }
        for (FingerIdentifier fingerId : FingerIdentifier.values()) {
            if (Arrays.equals(this.templates.get((Object)fingerId), other.templates.get((Object)fingerId))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this.guid.hashCode();
        for (FingerIdentifier fingerId : FingerIdentifier.values()) {
            hash = hash * 17 + Arrays.hashCode(this.templates.get((Object)fingerId));
        }
        return hash;
    }
}

