/*
 * Decompiled with CFR 0.152.
 */
package com.simprints.libsimprints;

import android.support.annotation.NonNull;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class Metadata {
    private final JSONObject json;

    public Metadata(@NonNull String jsonString) throws InvalidMetadataException {
        try {
            this.json = new JSONObject(jsonString);
        }
        catch (JSONException e) {
            throw new InvalidMetadataException("The metadata string is not a valid JSON object string.");
        }
        Iterator keys = this.json.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (this.json.optJSONArray(key) == null && this.json.optJSONObject(key) == null) continue;
            throw new InvalidMetadataException("Only boolean, string, integer and floating point values are allowed.");
        }
    }

    public Metadata() {
        this.json = new JSONObject();
    }

    @NonNull
    public Metadata put(@NonNull String key, boolean value) {
        return this.putObject(key, value);
    }

    @NonNull
    public Metadata put(@NonNull String key, double value) {
        return this.putObject(key, value);
    }

    @NonNull
    public Metadata put(@NonNull String key, long value) {
        return this.putObject(key, value);
    }

    @NonNull
    public Metadata put(@NonNull String key, @NonNull String value) {
        return this.putObject(key, value);
    }

    @NonNull
    public String toString() {
        return this.json.toString();
    }

    @NonNull
    private Metadata putObject(@NonNull String key, @NonNull Object value) {
        try {
            this.json.put(key, value);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public class InvalidMetadataException
    extends Exception {
        InvalidMetadataException(String message) {
            super(message);
        }
    }
}

