/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android.phase08preparepackage;

import com.simpligility.maven.plugins.android.AbstractAndroidMojo;
import com.simpligility.maven.plugins.android.CommandExecutor;
import com.simpligility.maven.plugins.android.ExecutionException;
import com.simpligility.maven.plugins.android.IncludeExcludeSet;
import com.simpligility.maven.plugins.android.InclusionExclusionResolver;
import com.simpligility.maven.plugins.android.configuration.D8;
import com.simpligility.maven.plugins.android.phase08preparepackage.DexCompiler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.util.DefaultFileSet;

@Mojo(name="d8", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class D8Mojo
extends AbstractAndroidMojo {
    private static final String JAR = "jar";
    @Parameter(property="android.dex.compiler", defaultValue="dex")
    private String dexCompiler;
    @Parameter
    private D8 d8;
    @Parameter(property="android.d8.jvmArguments", defaultValue="-Xmx1024M")
    private String[] d8JvmArguments;
    @Parameter(property="android.d8.intermediate", defaultValue="false")
    private boolean d8Intermediate;
    @Parameter(property="android.d8.mainDexList")
    private String d8MainDexList;
    @Parameter(property="android.d8.release", defaultValue="false")
    private boolean d8Release;
    @Parameter(property="android.d8.minApi")
    private Integer d8MinApi;
    @Parameter(property="android.d8.arguments")
    private String[] d8Arguments;
    @Parameter(property="android.proguard.obfuscatedJar")
    private File obfuscatedJar;
    @Parameter(property="skipDependencies", defaultValue="false")
    private boolean skipDependencies;
    @Parameter(property="artifactTypeSet")
    private IncludeExcludeSet artifactTypeSet;
    @Parameter(property="artifactSet")
    private IncludeExcludeSet artifactSet;
    private String[] parsedJvmArguments;
    private boolean parsedIntermediate;
    private String parsedMainDexList;
    private String[] parsedArguments;
    private DexCompiler parsedDexCompiler;
    private boolean parsedRelease;
    private Integer parsedMinApi;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.parseConfiguration();
        this.getLog().debug((CharSequence)("DexCompiler set to " + (Object)((Object)this.parsedDexCompiler)));
        if (this.parsedDexCompiler != DexCompiler.D8) {
            this.getLog().info((CharSequence)("Not executing D8Mojo because DEX compiler is set to " + (Object)((Object)this.parsedDexCompiler)));
            return;
        }
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        if (this.generateApk) {
            this.runD8(executor);
        }
        if (this.attachJar) {
            File jarFile = new File(this.targetDirectory + File.separator + this.finalName + ".jar");
            this.projectHelper.attachArtifact(this.project, JAR, this.project.getArtifact().getClassifier(), jarFile);
        }
        if (this.attachSources) {
            File apksources = this.createApkSourcesFile();
            this.projectHelper.attachArtifact(this.project, "apksources", apksources);
        }
    }

    private List<File> getDependencies() {
        ArrayList<File> libraries = new ArrayList<File>();
        for (Artifact artifact : InclusionExclusionResolver.filterArtifacts(this.getTransitiveDependencyArtifacts(new String[0]), this.skipDependencies, this.artifactTypeSet.getIncludes(), this.artifactTypeSet.getExcludes(), this.artifactSet.getIncludes(), this.artifactSet.getExcludes())) {
            if (!JAR.equals(artifact.getType())) continue;
            libraries.add(artifact.getFile());
        }
        return libraries;
    }

    private Set<File> getD8InputFiles() {
        HashSet<File> inputs = new HashSet<File>();
        if (this.obfuscatedJar != null && this.obfuscatedJar.exists()) {
            this.getLog().debug((CharSequence)("Adding dex input (obfuscatedJar) : " + this.obfuscatedJar));
            inputs.add(this.obfuscatedJar);
        } else {
            this.getLog().debug((CharSequence)"Using non-obfuscated input");
            File classesJar = new File(this.targetDirectory, this.finalName + ".jar");
            inputs.add(classesJar);
            this.getLog().debug((CharSequence)("Adding dex input from : " + classesJar));
            for (Artifact artifact : InclusionExclusionResolver.filterArtifacts(this.getTransitiveDependencyArtifacts(new String[0]), this.skipDependencies, this.artifactTypeSet.getIncludes(), this.artifactTypeSet.getExcludes(), this.artifactSet.getIncludes(), this.artifactSet.getExcludes())) {
                if (!artifact.getType().equals(JAR)) continue;
                this.getLog().debug((CharSequence)("Adding dex input : " + artifact.getFile()));
                inputs.add(artifact.getFile().getAbsoluteFile());
            }
        }
        return inputs;
    }

    private void parseConfiguration() {
        if (this.d8 != null) {
            this.parsedJvmArguments = this.d8.getJvmArguments() == null ? this.d8JvmArguments : this.d8.getJvmArguments();
            this.parsedIntermediate = this.d8.isIntermediate() == null ? this.d8Intermediate : this.d8.isIntermediate();
            this.parsedMainDexList = this.d8.getMainDexList() == null ? this.d8MainDexList : this.d8.getMainDexList();
            this.parsedArguments = this.d8.getArguments() == null ? this.d8Arguments : this.d8.getArguments();
            this.parsedDexCompiler = DexCompiler.valueOfIgnoreCase(this.dexCompiler);
            this.parsedRelease = this.d8.isRelease() == null ? this.release : this.d8.isRelease();
            this.parsedMinApi = this.d8.getMinApi() == null ? this.d8MinApi : this.d8.getMinApi();
        } else {
            this.parsedJvmArguments = this.d8JvmArguments;
            this.parsedIntermediate = this.d8Intermediate;
            this.parsedMainDexList = this.d8MainDexList;
            this.parsedArguments = this.d8Arguments;
            this.parsedDexCompiler = DexCompiler.valueOfIgnoreCase(this.dexCompiler);
            this.parsedRelease = this.d8Release;
            this.parsedMinApi = this.d8MinApi;
        }
    }

    private List<String> dexDefaultCommands() throws MojoExecutionException {
        List<String> commands = this.jarDefaultCommands();
        commands.add(this.getAndroidSdk().getD8JarPath());
        return commands;
    }

    private List<String> jarDefaultCommands() {
        List<String> commands = this.javaDefaultCommands();
        commands.add("-jar");
        return commands;
    }

    private List<String> javaDefaultCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        if (this.parsedJvmArguments != null) {
            for (String jvmArgument : this.parsedJvmArguments) {
                if (!jvmArgument.startsWith("-")) {
                    jvmArgument = "-" + jvmArgument;
                }
                this.getLog().debug((CharSequence)("Adding jvm argument " + jvmArgument));
                commands.add(jvmArgument);
            }
        }
        return commands;
    }

    private void runD8(CommandExecutor executor) throws MojoExecutionException {
        List<String> commands = this.dexDefaultCommands();
        Set<File> inputFiles = this.getD8InputFiles();
        if (this.parsedIntermediate) {
            commands.add("--intermediate");
        }
        if (this.parsedMainDexList != null) {
            commands.add("--main-dex-list" + this.parsedMainDexList);
        }
        if (this.parsedArguments != null) {
            for (String argument : this.parsedArguments) {
                commands.add(argument);
            }
        }
        if (this.parsedRelease) {
            commands.add("--release");
        }
        if (this.parsedMinApi != null) {
            commands.add("--min-api");
            commands.add(this.parsedMinApi.toString());
        }
        commands.add("--output");
        commands.add(this.targetDirectory.getAbsolutePath());
        File androidJar = this.getAndroidSdk().getAndroidJar();
        commands.add("--lib");
        commands.add(androidJar.getAbsolutePath());
        List<File> dependencies = this.getDependencies();
        for (File file : dependencies) {
            commands.add("--classpath");
            commands.add(file.getAbsolutePath());
        }
        for (File inputFile : inputFiles) {
            commands.add(inputFile.getAbsolutePath());
        }
        this.getLog().info((CharSequence)("Convert classes to Dex : " + this.targetDirectory));
        this.executeJava(commands, executor);
    }

    private String executeJava(List<String> commands, CommandExecutor executor) throws MojoExecutionException {
        String javaExecutable = D8Mojo.getJavaExecutable().getAbsolutePath();
        this.getLog().debug((CharSequence)(javaExecutable + " " + commands.toString()));
        try {
            executor.setCaptureStdOut(true);
            executor.executeCommand(javaExecutable, commands, this.project.getBasedir(), false);
            return executor.getStandardOut();
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }

    private static File getJavaExecutable() {
        String javaHome = System.getProperty("java.home");
        String slash = File.separator;
        return new File(javaHome + slash + "bin" + slash + "java");
    }

    protected File createApkSourcesFile() throws MojoExecutionException {
        File apksources = new File(this.targetDirectory, this.finalName + ".apksources");
        FileUtils.deleteQuietly((File)apksources);
        try {
            JarArchiver jarArchiver = new JarArchiver();
            jarArchiver.setDestFile(apksources);
            this.addDirectory(jarArchiver, this.assetsDirectory, "assets");
            this.addDirectory(jarArchiver, this.resourceDirectory, "res");
            this.addDirectory(jarArchiver, this.sourceDirectory, "src/main/java");
            this.addJavaResources(jarArchiver, this.resources);
            jarArchiver.createArchive();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("ArchiverException while creating .apksource file.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException while creating .apksource file.", (Exception)e);
        }
        return apksources;
    }

    protected String endWithSlash(String prefix) {
        if (!(prefix = (String)StringUtils.defaultIfEmpty((CharSequence)prefix, (CharSequence)"/")).endsWith("/")) {
            prefix = prefix + "/";
        }
        return prefix;
    }

    protected void addDirectory(JarArchiver jarArchiver, File directory, String prefix) {
        if (directory != null && directory.exists()) {
            DefaultFileSet fileSet = new DefaultFileSet();
            fileSet.setPrefix(this.endWithSlash(prefix));
            fileSet.setDirectory(directory);
            jarArchiver.addFileSet((FileSet)fileSet);
        }
    }

    protected void addJavaResources(JarArchiver jarArchiver, List<Resource> javaResources) {
        for (Resource javaResource : javaResources) {
            this.addJavaResource(jarArchiver, javaResource);
        }
    }

    protected void addJavaResource(JarArchiver jarArchiver, Resource javaResource) {
        File javaResourceDirectory;
        if (javaResource != null && (javaResourceDirectory = new File(javaResource.getDirectory())).exists()) {
            DefaultFileSet javaResourceFileSet = new DefaultFileSet();
            javaResourceFileSet.setDirectory(javaResourceDirectory);
            javaResourceFileSet.setPrefix(this.endWithSlash("src/main/resources"));
            jarArchiver.addFileSet((FileSet)javaResourceFileSet);
        }
    }
}

