/*
 * Decompiled with CFR 0.152.
 */
package com.simple.spiderman;

import android.content.Context;
import com.simple.spiderman.CrashModel;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;

public class SpiderMan
implements Thread.UncaughtExceptionHandler {
    public static final String TAG = "SpiderMan";
    private static SpiderMan spiderMan = new SpiderMan();
    private Thread.UncaughtExceptionHandler mExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
    private OnCrashListener mOnCrashListener;

    private SpiderMan() {
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    public static SpiderMan init(Context context) {
        return spiderMan;
    }

    @Override
    public void uncaughtException(Thread t, Throwable ex) {
        CrashModel model = this.parseCrash(ex);
        if (this.mOnCrashListener != null) {
            this.mOnCrashListener.onCrash(t, ex, model);
        }
        this.mExceptionHandler.uncaughtException(t, ex);
    }

    private CrashModel parseCrash(Throwable ex) {
        CrashModel model = new CrashModel();
        try {
            model.setEx(ex);
            model.setTime(new Date().getTime());
            if (ex.getCause() != null) {
                ex = ex.getCause();
            }
            model.setExceptionMsg(ex.getMessage());
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            pw.flush();
            String exceptionType = ex.getClass().getName();
            if (ex.getStackTrace() != null && ex.getStackTrace().length > 0) {
                StackTraceElement element = ex.getStackTrace()[0];
                model.setLineNumber(element.getLineNumber());
                model.setClassName(element.getClassName());
                model.setFileName(element.getFileName());
                model.setMethodName(element.getMethodName());
                model.setExceptionType(exceptionType);
            }
            model.setFullException(sw.toString());
        }
        catch (Exception e) {
            return model;
        }
        return model;
    }

    public void setOnCrashListener(OnCrashListener listener) {
        this.mOnCrashListener = listener;
    }

    public static interface OnCrashListener {
        public void onCrash(Thread var1, Throwable var2, CrashModel var3);
    }
}

