/*
 * Decompiled with CFR 0.152.
 */
package com.simple.spiderman;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.simple.spiderman.CrashModel;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;

public class SpiderMan
implements Thread.UncaughtExceptionHandler {
    public static final String TAG = "SpiderMan";
    private static SpiderMan spiderMan = new SpiderMan();
    private Thread.UncaughtExceptionHandler mExceptionHandler;
    private OnCrashListener mOnCrashListener;

    private SpiderMan() {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Looper.loop();
                        }
                    }
                    catch (Throwable e) {
                        if (SpiderMan.this.mOnCrashListener == null) continue;
                        CrashModel model = SpiderMan.this.parseCrash(e);
                        SpiderMan.this.mOnCrashListener.onCrash(Looper.getMainLooper().getThread(), e, model);
                        continue;
                    }
                    break;
                }
            }
        });
        this.mExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    public static SpiderMan init(Context context) {
        return spiderMan;
    }

    @Override
    public void uncaughtException(Thread t, Throwable ex) {
        CrashModel model = this.parseCrash(ex);
        if (this.mOnCrashListener != null) {
            this.mOnCrashListener.onCrash(t, ex, model);
        }
        this.mExceptionHandler.uncaughtException(t, ex);
    }

    private CrashModel parseCrash(Throwable ex) {
        CrashModel model = new CrashModel();
        model.setEx(ex);
        model.setTime(new Date().getTime());
        StringBuilder msgBuilder = new StringBuilder();
        String exceptionMsg = null;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        pw.flush();
        String exceptionType = ex.getClass().getName();
        exceptionMsg = ex.getMessage();
        msgBuilder.append(ex.getMessage());
        msgBuilder.append("\n");
        if (ex.getStackTrace() != null && ex.getStackTrace().length > 0) {
            StackTraceElement element = ex.getStackTrace()[0];
            model.setExceptionMsg(exceptionMsg);
            model.setLineNumber(element.getLineNumber());
            model.setClassName(element.getClassName());
            model.setFileName(element.getFileName());
            model.setMethodName(element.getMethodName());
            model.setExceptionType(exceptionType);
        }
        model.setFullException(sw.toString());
        return model;
    }

    public void setOnCrashListener(OnCrashListener listener) {
        this.mOnCrashListener = listener;
    }

    public static interface OnCrashListener {
        public void onCrash(Thread var1, Throwable var2, CrashModel var3);
    }
}

