/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script.runners;

import java.io.File;
import org.sikuli.basics.FileManager;
import org.sikuli.basics.Settings;
import org.sikuli.script.App;
import org.sikuli.script.ImagePath;
import org.sikuli.script.runners.JythonRunner;
import org.sikuli.script.support.IScriptRunner;
import org.sikuli.script.support.RunTime;

public class RobotRunner
extends JythonRunner {
    public static final String NAME = "Robot";
    public static final String TYPE = "text/robot";
    public static final String[] EXTENSIONS = new String[]{"robot"};
    private static final RunTime RUN_TIME = RunTime.get();

    @Override
    protected int doEvalScript(String code, IScriptRunner.Options options) {
        File scriptFolder;
        boolean showReport = true;
        if (code.length() > 7 && code.substring(0, 7).contains("silent\n")) {
            code = code.substring(7);
            showReport = false;
        }
        if (null == (scriptFolder = new File(ImagePath.getBundlePath()))) {
            this.log(-1, "runRobot: no scriptfolder (bundle path)", new Object[0]);
            return -1;
        }
        File fRobotWork = new File(scriptFolder.getAbsolutePath() + ".robot");
        FileManager.deleteFileOrFolder(fRobotWork);
        fRobotWork.mkdir();
        String sName = scriptFolder.getName().replace(".sikuli", "");
        File fPyCode = new File(scriptFolder, sName + ".py");
        String pyCode = FileManager.readFileToString(fPyCode);
        int prefix = pyCode.indexOf("\"\"\")");
        if (prefix > 0) {
            pyCode = pyCode.substring(prefix + 4).trim();
            int refLib = code.indexOf("./inline/");
            String inlineLib = "";
            File fInline = null;
            String fpInline = "";
            if (!pyCode.isEmpty()) {
                if (refLib < 0) {
                    this.log(-1, "runRobot: inline code ignored - no ./inline/", new Object[0]);
                }
                inlineLib = code.substring(refLib + 9);
                inlineLib = inlineLib.substring(0, inlineLib.indexOf("\n")).trim();
                fInline = new File(fRobotWork, inlineLib + ".py");
                pyCode = "from sikuli import *\n" + pyCode;
                FileManager.writeStringToFile(pyCode, fInline);
                fpInline = FileManager.slashify(fInline.getAbsolutePath(), false);
                code = code.replace("./inline/" + inlineLib, fpInline);
            } else if (refLib > -1) {
                this.log(-1, "runRobot: having ./inline/, but no inline code found", new Object[0]);
                return -1;
            }
        }
        File fRobot = new File(fRobotWork, sName + ".robot");
        FileManager.writeStringToFile(code, fRobot);
        jythonSupport.interpreterExecString("from sikuli import *; from threading import currentThread; currentThread().name = \"MainThread\"");
        String robotCmd = String.format("ret = robot.run(\"%s\", outputdir=\"%s\")", fRobot, fRobotWork);
        File fReport = new File(fRobotWork, "report.html");
        String urlReport = fReport.getAbsolutePath();
        if (RunTime.get().runningWindows) {
            robotCmd = robotCmd.replaceAll("\\\\", "\\\\\\\\");
            urlReport = "/" + urlReport.replaceAll("\\\\", "/");
        }
        jythonSupport.interpreterExecString(robotCmd + "; print \"robot.run returned:\", ret; " + String.format("print \"robot.run output is here:\\n%s\";", fRobotWork.getAbsolutePath().replaceAll("\\\\", "\\\\\\\\")));
        if (showReport && new File(fRobotWork, "report.html").exists()) {
            App.openLink("file:" + urlReport);
        }
        return 0;
    }

    @Override
    public boolean isSupported() {
        File fLibRobot = new File(RunTime.get().fSikulixLib, "robot");
        return fLibRobot.exists();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String[] getExtensions() {
        return (String[])EXTENSIONS.clone();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected void doInit(String[] args) {
        super.doInit(args);
        if (null != Settings.BundlePath) {
            jythonSupport.appendSysPath(new File(Settings.BundlePath).getParent());
        }
        jythonSupport.interpreterExecString("import robot");
    }

    @Override
    public String[] getFileEndings() {
        String[] extensions = this.getExtensions();
        String[] endings = new String[extensions.length];
        for (int i = 0; i < extensions.length; ++i) {
            endings[i] = "." + extensions[i];
        }
        return endings;
    }
}

