/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script.runnerSupport;

import java.io.File;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.RubyInstanceConfig;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.ScriptingContainer;
import org.sikuli.basics.Debug;
import org.sikuli.basics.FileManager;
import org.sikuli.script.runnerSupport.IRunnerSupport;
import org.sikuli.script.support.RunTime;

public class JRubySupport
implements IRunnerSupport {
    private static final String me = "JRuby: ";
    private static int lvl = 3;
    private static JRubySupport instance = null;
    private static ScriptingContainer interpreter = null;
    private static int savedpathlen = 0;
    private static final String SCRIPT_HEADER = "# coding: utf-8\nrequire 'Lib/sikulix'\ninclude Sikulix\n";
    private static ArrayList<String> sysargv = null;
    private int errorLine;
    private int errorColumn;
    private String errorType;
    private String errorText;
    private int errorClass;
    private String errorTrace;
    private static final int RB_SYNTAX = 0;
    private static final int RB_RUNTIME = 1;
    private static final int RB_JAVA = 2;
    private static final int RB_UNKNOWN = -1;

    public void log(int level, String message, Object ... args) {
        Debug.logx(level, me + message, args);
    }

    private JRubySupport() {
    }

    public static JRubySupport get() {
        if (null == instance) {
            instance = new JRubySupport();
            RunTime.get().exportLib();
            instance.interpreterInitialization();
        }
        return instance;
    }

    public static boolean isSupported() {
        try {
            Class.forName("org.jruby.embed.ScriptingContainer");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public void interpreterInitialization() {
        if (interpreter == null) {
            RunTime.get().fSikulixLib.getAbsolutePath();
            try {
                Class.forName("org.jruby.embed.ScriptingContainer");
            }
            catch (ClassNotFoundException e) {
                this.log(-1, "not found on classpath", new Object[0]);
                return;
            }
            try {
                interpreter = new ScriptingContainer(LocalContextScope.THREADSAFE);
                interpreter.setCompileMode(RubyInstanceConfig.CompileMode.JIT);
            }
            catch (Exception e) {
                this.log(-1, "init problem: %s", e.getMessage());
                interpreter = null;
            }
        }
    }

    public boolean interpreterRedirect(PrintStream stdout, PrintStream stderr) {
        if (interpreter == null) {
            return false;
        }
        try {
            interpreter.setOutput(stdout);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log(-1, "JRuby: redirect STDOUT: %s", e.getMessage());
            return false;
        }
        try {
            interpreter.setError(stderr);
        }
        catch (Exception e) {
            this.log(-1, "JRuby: redirect STDERR: %s", e.getMessage());
            return false;
        }
        return true;
    }

    public List<String> interpreterGetLoadPaths() {
        if (null == interpreter) {
            return null;
        }
        return interpreter.getLoadPaths();
    }

    public void executeScriptHeader(List<String> codeBefore, String ... paths) {
        List<String> path = this.interpreterGetLoadPaths();
        if (null == path) {
            return;
        }
        String sikuliLibPath = RunTime.get().fSikulixLib.getAbsolutePath();
        if (path.size() == 0 || !FileManager.pathEquals(path.get(0), sikuliLibPath)) {
            int i;
            this.log(lvl, "executeScriptHeader: adding SikuliX Lib path to sys.path\n" + sikuliLibPath, new Object[0]);
            int pathLength = path.size();
            String[] pathNew = new String[pathLength + 1];
            pathNew[0] = sikuliLibPath;
            for (i = 0; i < pathLength; ++i) {
                pathNew[i + 1] = path.get(i);
            }
            for (i = 0; i < pathLength; ++i) {
                path.set(i, pathNew[i]);
            }
            path.add(pathNew[pathNew.length - 1]);
        }
        if (savedpathlen == 0) {
            savedpathlen = this.interpreterGetLoadPaths().size();
        }
        while (this.interpreterGetLoadPaths().size() > savedpathlen) {
            this.interpreterGetLoadPaths().remove(savedpathlen);
        }
        for (String syspath : paths) {
            path.add(new File(syspath).getAbsolutePath());
        }
        this.interpreterRunScriptletString(SCRIPT_HEADER);
        if (codeBefore != null) {
            StringBuilder buffer = new StringBuilder();
            for (String line : codeBefore) {
                buffer.append(line);
            }
            this.interpreterRunScriptletString(buffer.toString());
        }
    }

    public void fillSysArgv(File filename, String[] argv) {
        sysargv = new ArrayList();
        if (filename != null) {
            sysargv.add(filename.getAbsolutePath());
        }
        if (argv != null) {
            sysargv.addAll(Arrays.asList(argv));
        }
        if (interpreter != null) {
            interpreter.setArgv(sysargv.toArray(new String[0]));
        }
    }

    public Object interpreterRunScriptletString(String script) {
        if (null == interpreter) {
            return null;
        }
        return interpreter.runScriptlet(script);
    }

    public Object interpreterRunScriptletFile(Reader reader, String filename) throws Throwable {
        if (null == interpreter) {
            return null;
        }
        return interpreter.runScriptlet(reader, filename);
    }

    public void interpreterTerminate() {
        if (interpreter != null) {
            interpreter.terminate();
            interpreter = null;
        }
    }

    public int findErrorSource(Throwable thr, String filename, int headerOffset) {
        String err;
        block13: {
            Matcher mLine;
            block12: {
                err = thr.getMessage();
                this.errorLine = -1;
                this.errorColumn = -1;
                this.errorClass = -1;
                this.errorType = "--UnKnown--";
                this.errorText = "--UnKnown--";
                if (!err.startsWith("(SyntaxError)")) break block12;
                Pattern pLineS = Pattern.compile("(?<=:)(\\d+):(.*)");
                mLine = pLineS.matcher(err);
                if (!mLine.find()) break block13;
                this.errorText = mLine.group(2) == null ? this.errorText : mLine.group(2);
                this.errorLine = Integer.parseInt(mLine.group(1));
                this.errorColumn = -1;
                this.errorClass = 0;
                this.errorType = "SyntaxError";
                break block13;
            }
            Pattern type = Pattern.compile("(?<=\\()(\\w*)");
            mLine = type.matcher(err);
            if (mLine.find()) {
                this.errorType = mLine.group(1);
            }
            Throwable cause = thr.getCause();
            for (StackTraceElement line : cause.getStackTrace()) {
                if (!line.getFileName().equals(filename)) continue;
                this.errorText = cause.getMessage();
                this.errorColumn = -1;
                this.errorLine = line.getLineNumber();
                this.errorClass = 1;
                this.errorText = thr.getMessage();
                Pattern sikType = Pattern.compile("(?<=org.sikuli.script.)(.*)(?=:)");
                Matcher mSikType = sikType.matcher(this.errorText);
                if (mSikType.find()) {
                    this.errorType = mSikType.group(1);
                    break;
                }
                if (!this.errorType.equals("RuntimeError")) break;
                this.errorClass = 2;
                break;
            }
        }
        String msg = "script";
        if (this.errorLine != -1) {
            msg = msg + " stopped with error in line " + (this.errorLine - headerOffset);
            if (this.errorColumn != -1) {
                msg = msg + " at column " + this.errorColumn;
            }
        } else {
            msg = msg + "] stopped with error at line --unknown--";
        }
        if (this.errorClass == 1 || this.errorClass == 0) {
            Debug.error(msg, new Object[0]);
            Debug.error(this.errorType + " ( " + this.errorText + " )", new Object[0]);
            if (this.errorClass == 1) {
                Throwable cause = thr.getCause();
                StackTraceElement[] stack = cause.getStackTrace();
                StringBuilder builder = new StringBuilder();
                for (StackTraceElement line : stack) {
                    builder.append(line.getLineNumber());
                    builder.append(":\t");
                    builder.append(line.getClassName());
                    builder.append(" ( ");
                    builder.append(line.getMethodName());
                    builder.append(" )\t");
                    builder.append(line.getFileName());
                    builder.append('\n');
                }
                this.errorTrace = builder.toString();
                if (this.errorTrace.length() > 0) {
                    Debug.error("--- Traceback --- error source first\nline: class ( method ) file \n" + this.errorTrace + "[error] --- Traceback --- end --------------", new Object[0]);
                    this.log(lvl + 2, "--- Traceback --- error source first\nline: class ( method ) file \n" + this.errorTrace + "[error] --- Traceback --- end --------------", new Object[0]);
                }
            }
        } else if (this.errorClass != 2) {
            Debug.error(msg, new Object[0]);
            Debug.error("Could not evaluate error source nor reason. Analyze StackTrace!", new Object[0]);
            Debug.error(err, new Object[0]);
        }
        return this.errorLine - headerOffset;
    }

    @Override
    public boolean runObserveCallback(Object[] args) {
        boolean result = false;
        Object callback = args[0];
        Object e = args[1];
        try {
            Class<?> rubyProcClass = callback.getClass();
            Method getRuntime = rubyProcClass.getMethod("getRuntime", new Class[0]);
            Object runtime = getRuntime.invoke(callback, new Object[0]);
            Class<?> runtimeClass = getRuntime.getReturnType();
            Method getCurrentContext = runtimeClass.getMethod("getCurrentContext", new Class[0]);
            Object context = getCurrentContext.invoke(runtime, new Object[0]);
            Class<?> jrubyUtil = Class.forName("org.jruby.javasupport.JavaUtil");
            Method convertJavaToRuby = jrubyUtil.getMethod("convertJavaToRuby", runtimeClass, Object.class);
            Object paramForRuby = convertJavaToRuby.invoke(null, runtime, e);
            Object iRubyObject = Array.newInstance(Class.forName("org.jruby.runtime.builtin.IRubyObject"), 1);
            Array.set(iRubyObject, 0, paramForRuby);
            Method call = rubyProcClass.getMethod("call", context.getClass(), iRubyObject.getClass());
            call.invoke(callback, context, iRubyObject);
            result = true;
        }
        catch (Exception ex) {
            String msg = ex.getMessage();
            Debug.error("ObserverCallBack: problem with scripting handler: %s\n%s\n%s", me, callback, msg);
        }
        return result;
    }
}

