/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.natives;

import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.util.StringUtils;
import org.sikuli.basics.Debug;
import org.sikuli.natives.CommandExecutorException;
import org.sikuli.natives.CommandExecutorHelper;
import org.sikuli.natives.CommandExecutorResult;
import org.sikuli.natives.OSUtil;
import org.sikuli.script.App;
import org.sikuli.script.Region;

public class LinuxUtil
implements OSUtil {
    String currentWindowTitle = "";
    private static boolean wmctrlAvail = true;
    private static boolean xdoToolAvail = true;
    private String[] wmctrlLine = new String[0];

    @Override
    public boolean open(App app) {
        int pid = this.open(app.getExec());
        app.setPID(pid);
        return pid > -1;
    }

    private int open(String appName) {
        try {
            String[] cmd = new String[]{"sh", "-c", "\"" + appName + "\"", "&"};
            Process p = Runtime.getRuntime().exec(cmd);
            InputStream in = p.getInputStream();
            byte[] pidBytes = new byte[64];
            int len = in.read(pidBytes);
            String pidStr = new String(pidBytes, 0, len);
            String[] pidStrSplit = pidStr.split("\\s");
            int pid = Integer.parseInt(pidStrSplit[pidStrSplit.length - 1]);
            p.waitFor();
            return pid;
        }
        catch (Exception e) {
            System.out.println("[error] openApp:\n" + e.getMessage());
            return -1;
        }
    }

    @Override
    public boolean switchto(App app) {
        int ret = -1;
        this.currentWindowTitle = "";
        if (app.getPID() > 0 && (ret = this.switchto(app.getPID(), 0)) > -1) {
            app.setFocused(true);
            app.setWindow(this.currentWindowTitle);
        }
        return ret > -1;
    }

    @Override
    public App switchto(String title, int index) {
        App app = new App();
        return app;
    }

    private int switchto(int pid, int num) {
        if (!this.isAvailable(wmctrlAvail, "switchApp", "wmctrl")) {
            return -1;
        }
        String[] winLine = this.findWindow("" + pid, num, SearchType.PID);
        if (winLine == null || winLine.length < 1) {
            return -1;
        }
        this.currentWindowTitle = winLine[9];
        return this.bringWindowToFront(winLine[0], pid);
    }

    @Override
    public boolean close(App app) {
        int ret = app.getPID() > 0 ? this.close(app.getPID()) : this.close(app.getExec());
        return ret == 0;
    }

    private int close(int pid) {
        if (!this.isAvailable(wmctrlAvail, "closeApp", "wmctrl")) {
            return -1;
        }
        String[] winLine = this.findWindow("" + pid, 0, SearchType.PID);
        if (winLine == null) {
            return -1;
        }
        String[] cmd = new String[]{"wmctrl", "-ic", winLine[0]};
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            p.waitFor();
            return p.exitValue();
        }
        catch (Exception e) {
            System.out.println("[error] closeApp:\n" + e.getMessage());
            return -1;
        }
    }

    private int close(String appName) {
        try {
            CommandExecutorResult result1 = CommandExecutorHelper.execute("pidof " + appName, 0);
            String pid = result1.getStandardOutput();
            if (pid == null || pid.isEmpty()) {
                throw new CommandExecutorException("No app could be found with Name '" + appName + "'");
            }
            return CommandExecutorHelper.execute("kill " + pid, 0).getExitValue();
        }
        catch (Exception e) {
            Integer windowPID = this.findWindowPID(appName, 1);
            if (windowPID > 1) {
                try {
                    return CommandExecutorHelper.execute("kill " + windowPID.toString(), 0).getExitValue();
                }
                catch (Exception e1) {
                    e.addSuppressed(e1);
                }
            }
            System.out.println("[error] closeApp:\n" + e.getMessage());
            return -1;
        }
    }

    @Override
    public Rectangle getFocusedWindow() {
        if (!this.isAvailable(xdoToolAvail, "getFocusedWindow", "xdoTool")) {
            return null;
        }
        String[] cmd = new String[]{"xdotool", "getactivewindow"};
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            InputStream in = p.getInputStream();
            BufferedReader bufin = new BufferedReader(new InputStreamReader(in));
            String str = bufin.readLine();
            long id = 0L;
            if (str != null) {
                id = Integer.parseInt(str);
                String hexid = String.format("0x%08x", id);
                return this.findRegion(hexid, 0, SearchType.WINDOW_ID);
            }
        }
        catch (IOException e) {
            System.out.println("[error] getFocusedWindow:\n" + e.getMessage());
        }
        return null;
    }

    @Override
    public Rectangle getWindow(App app) {
        return this.getWindow(app, 0);
    }

    @Override
    public Rectangle getWindow(App app, int num) {
        return this.getWindow(app.getPID(), num);
    }

    @Override
    public Rectangle getWindow(String appName) {
        return this.getWindow(appName, 0);
    }

    private Rectangle findRegion(String appName, int winNum, SearchType type) {
        String[] winLine = this.findWindow(appName, winNum, type);
        if (winLine != null && winLine.length >= 7) {
            int x = new Integer(winLine[3]);
            int y = Integer.parseInt(winLine[4]);
            int w = Integer.parseInt(winLine[5]);
            int h = Integer.parseInt(winLine[6]);
            return new Rectangle(x, y, w, h);
        }
        return null;
    }

    private String[] findWindow(String appName, int winNum, SearchType type) {
        String[] found = new String[]{};
        int numFound = 0;
        try {
            String[] lines;
            CommandExecutorResult result = CommandExecutorHelper.execute("wmctrl -lpGx", 0);
            int slash = appName.lastIndexOf("/");
            if (slash >= 0) {
                appName = appName.substring(slash + 1);
            }
            if (type == SearchType.APP_NAME) {
                appName = appName.toLowerCase();
            }
            for (String str : lines = result.getStandardOutput().split("\\n")) {
                String[] winLine = str.split("\\s+", 10);
                boolean ok = false;
                if (type == SearchType.WINDOW_ID) {
                    if (appName.equals(winLine[0])) {
                        ok = true;
                    }
                } else if (type == SearchType.PID) {
                    if (appName.equals(winLine[2])) {
                        ok = true;
                    }
                } else if (type == SearchType.APP_NAME) {
                    String winLineName = winLine[7].toLowerCase();
                    if (appName.equals(winLineName)) {
                        ok = true;
                    }
                    if (!ok && winLine[9].toLowerCase().contains(appName)) {
                        ok = true;
                    }
                }
                if (!ok) continue;
                if (numFound >= winNum) {
                    found = winLine;
                    break;
                }
                ++numFound;
            }
        }
        catch (Exception e) {
            System.out.println("[error] findWindow:\n" + e.getMessage());
            return null;
        }
        return found;
    }

    private int findWindowPID(String appName, int winNum) {
        this.wmctrlLine = new String[0];
        String[] windowLine = this.findWindow(appName, winNum, SearchType.APP_NAME);
        if (windowLine != null && windowLine.length > 1) {
            this.wmctrlLine = windowLine;
            return Integer.parseInt(windowLine[2]);
        }
        return -1;
    }

    private Rectangle getWindow(String appName, int winNum) {
        return this.findRegion(appName, winNum, SearchType.APP_NAME);
    }

    private Rectangle getWindow(int pid) {
        return this.getWindow(pid, 0);
    }

    private Rectangle getWindow(int pid, int winNum) {
        return this.findRegion("" + pid, winNum, SearchType.PID);
    }

    private int bringWindowToFront(String windowID, int pid) {
        try {
            CommandExecutorHelper.execute("wmctrl -ia " + windowID, 0);
            return pid;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("[error] switchApp:\n" + e.getMessage());
            return -1;
        }
    }

    @Override
    public List<Region> getWindows(App app) {
        return new ArrayList<Region>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkFeatureAvailability() {
        List<CommandLine> commands = Arrays.asList(CommandLine.parse((String)"wmctrl -m"), CommandLine.parse((String)"xdotool -v"));
        for (CommandLine cmd : commands) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            String commandstring = StringUtils.toString((String[])cmd.toStrings(), (String)" ");
            try {
                DefaultExecutor executor = new DefaultExecutor();
                executor.setExitValue(0);
                executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)outputStream));
                executor.execute(cmd);
            }
            catch (ExecuteException e) {
                Debug.info("App: command %s ran, but failed: `%s'. Hoping for the best", commandstring, e.toString());
            }
            catch (IOException e) {
                String executable = cmd.toStrings()[0];
                if (executable.equals("wmctrl")) {
                    wmctrlAvail = false;
                }
                if (executable.equals("xdotool")) {
                    xdoToolAvail = false;
                }
                Debug.error("App: command %s is not executable, the App features will not work", executable);
            }
            finally {
                LinuxUtil.logCommandSysout(commandstring, outputStream);
            }
        }
    }

    private static void logCommandSysout(String commandstring, ByteArrayOutputStream outputStream) {
        if (outputStream.size() > 0) {
            Debug.log(4, "command '" + commandstring + "' output:\n" + outputStream.toString(), new Object[0]);
        }
    }

    private boolean isAvailable(boolean module, String cmd, String feature) {
        if (module) {
            return true;
        }
        Debug.error("%s: feature %s: not available or not working", cmd, feature);
        return false;
    }

    @Override
    public App get(App app) {
        if (app == null) {
            return app;
        }
        int pid = app.getPID();
        if (!app.isClosing() && pid < 0) {
            if (app.getNameGiven() != null && !app.getNameGiven().isEmpty()) {
                pid = this.findWindowPID(app.getNameGiven(), 0);
                app.setPID(pid);
            }
            return app;
        }
        if (app.isClosing() && pid > -1) {
            DefaultExecutor executor = new DefaultExecutor();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)outputStream));
            CommandLine command = CommandLine.parse((String)("ps -p " + pid));
            try {
                executor.execute(command);
                app.setPID(pid);
            }
            catch (Exception e) {
                if (outputStream.toString().split("\\n").length == 1) {
                    app.setPID(-1);
                    app.setWindow("");
                }
                Debug.log(3, "[error] LinuxUtil::executeCommand: %s (%s)", command, e.getMessage());
                LinuxUtil.logCommandSysout(command.toString(), outputStream);
            }
        }
        return app;
    }

    @Override
    public List<App> getApps(String name) {
        return null;
    }

    private static enum SearchType {
        APP_NAME,
        WINDOW_ID,
        PID;

    }
}

