/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.natives;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.sikuli.natives.CommandExecutorException;
import org.sikuli.natives.CommandExecutorResult;

public class CommandExecutorHelper {
    public static CommandExecutorResult execute(String commandString, int expectedExitValue) throws Exception {
        ByteArrayOutputStream error = new ByteArrayOutputStream();
        ByteArrayOutputStream stout = new ByteArrayOutputStream();
        CommandLine cmd = CommandLine.parse((String)commandString);
        try {
            DefaultExecutor executor = new DefaultExecutor();
            executor.setExitValue(expectedExitValue);
            executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)stout, (OutputStream)error));
            int exitValue = executor.execute(cmd);
            return new CommandExecutorResult(exitValue, stout.toString(), error.toString());
        }
        catch (Exception e) {
            int exitValue = -1;
            if (e instanceof ExecuteException) {
                exitValue = ((ExecuteException)((Object)e)).getExitValue();
            }
            throw new CommandExecutorException("error in command " + cmd.toString(), new CommandExecutorResult(exitValue, stout.toString(), error.toString()));
        }
    }
}

