/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.basics;

import java.awt.Color;
import java.awt.Container;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import org.sikuli.basics.Debug;
import org.sikuli.script.support.Commons;

public class SplashFrame
extends JFrame {
    private static JFrame splash = null;
    private static long start = 0L;
    private JLabel lbl;
    private JLabel txt;
    private Container pane;
    private int proSize;
    private int fw;
    private int fh;

    public static void displaySplash(String[] args) {
        if (args == null) {
            if (splash != null) {
                splash.dispose();
            }
            if (start > 0L) {
                Debug.log(3, "Sikuli-Script startup: " + (new Date().getTime() - start), new Object[0]);
                start = 0L;
            }
            return;
        }
        if (args.length > 0 && (args[0].contains("-testSetup") || args[0].startsWith("-i"))) {
            start = new Date().getTime();
            String[] splashArgs = new String[]{"splash", "#", "#" + Commons.getSXVersionAPI(), "", "#", "#... starting - please wait ..."};
            for (String e : args) {
                splashArgs[3] = splashArgs[3] + e + " ";
            }
            splashArgs[3] = splashArgs[3].trim();
            splash = new SplashFrame(splashArgs);
        }
    }

    public static void displaySplashFirstTime(String[] args) {
        if (args == null) {
            if (splash != null) {
                splash.dispose();
            }
            if (start > 0L) {
                Debug.log(3, "Sikuli-IDE environment setup: " + (new Date().getTime() - start), new Object[0]);
                start = 0L;
            }
            return;
        }
        start = new Date().getTime();
        String[] splashArgs = new String[]{"splash", "#", "#" + Commons.getSXVersionIDE(), "", "#", "#... setting up environement - please wait ..."};
        splash = new SplashFrame(splashArgs);
    }

    public SplashFrame(String type) {
        this.init(new String[]{type});
    }

    public SplashFrame(String[] args) {
        this.init(args);
    }

    private void init(String[] args) {
        this.setResizable(false);
        this.setUndecorated(true);
        this.pane = this.getContentPane();
        if ("download".equals(args[0])) {
            this.pane.setLayout(new BoxLayout(this.pane, 1));
            this.pane.add(new JLabel(" "));
            this.lbl = new JLabel("");
            this.lbl.setAlignmentX(0.5f);
            this.pane.add(this.lbl);
            this.pane.add(new JLabel(" "));
            this.txt = new JLabel("... waiting");
            this.txt.setAlignmentX(0.5f);
            this.pane.add(this.txt);
            this.fw = 350;
            this.fh = 80;
        }
        if ("splash".equals(args[0])) {
            String e;
            this.pane.setLayout(new BoxLayout(this.pane, 1));
            this.pane.setBackground(Color.yellow);
            int n = args.length;
            int l = 0;
            int nlbl = 0;
            for (int i = 1; i < n; ++i) {
                e = args[i];
                if (e.length() > l) {
                    l = e.length();
                }
                if (e.length() <= 1 || !e.startsWith("#")) continue;
                ++nlbl;
            }
            JLabel[] lbls = new JLabel[nlbl];
            nlbl = 0;
            for (int i = 1; i < n; ++i) {
                e = args[i];
                if (e.startsWith("#")) {
                    if (e.length() > 1) {
                        lbls[nlbl] = new JLabel(e.substring(1));
                        lbls[nlbl].setAlignmentX(0.5f);
                        this.pane.add(lbls[nlbl]);
                        ++nlbl;
                    }
                    this.pane.add(new JSeparator());
                    continue;
                }
                this.pane.add(new JLabel(e));
            }
            this.fw = 10 + 10 * l;
            this.fh = 10 + n * 15 + nlbl * 15;
        }
        this.pack();
        this.setSize(this.fw, this.fh);
        this.setLocationRelativeTo(null);
        this.setAlwaysOnTop(true);
        this.setVisible(true);
    }

    public void setProFile(String proFile) {
        this.lbl.setText("Downloading: " + proFile);
    }

    public void setProSize(int proSize) {
        this.proSize = proSize;
    }

    public void setProDone(int done) {
        if (done < 0) {
            this.txt.setText(" ..... failed !!!");
        } else if (this.proSize > 0) {
            this.txt.setText(done + " % out of " + this.proSize + " KB");
        } else {
            this.txt.setText(done + " KB out of ??? KB");
        }
        this.repaint();
    }

    public void closeAfter(int secs) {
        try {
            Thread.sleep(secs * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setVisible(false);
    }
}

