/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.jetty.websocket.common.extensions;

import com.signalfx.shaded.jetty.util.StringUtil;
import com.signalfx.shaded.jetty.util.component.ContainerLifeCycle;
import com.signalfx.shaded.jetty.util.component.Dumpable;
import com.signalfx.shaded.jetty.util.component.LifeCycle;
import com.signalfx.shaded.jetty.util.compression.DeflaterPool;
import com.signalfx.shaded.jetty.util.compression.InflaterPool;
import com.signalfx.shaded.jetty.websocket.api.WebSocketException;
import com.signalfx.shaded.jetty.websocket.api.extensions.Extension;
import com.signalfx.shaded.jetty.websocket.api.extensions.ExtensionConfig;
import com.signalfx.shaded.jetty.websocket.api.extensions.ExtensionFactory;
import com.signalfx.shaded.jetty.websocket.common.extensions.AbstractExtension;
import com.signalfx.shaded.jetty.websocket.common.extensions.compress.CompressExtension;
import com.signalfx.shaded.jetty.websocket.common.scopes.WebSocketContainerScope;
import java.io.IOException;

public class WebSocketExtensionFactory
extends ExtensionFactory
implements LifeCycle,
Dumpable {
    private final ContainerLifeCycle containerLifeCycle;
    private final WebSocketContainerScope container;
    private final InflaterPool inflaterPool = new InflaterPool(-1, true);
    private final DeflaterPool deflaterPool = new DeflaterPool(-1, -1, true);

    public WebSocketExtensionFactory(WebSocketContainerScope container) {
        this.containerLifeCycle = new ContainerLifeCycle(){

            @Override
            public String toString() {
                return String.format("%s@%x{%s}", WebSocketExtensionFactory.class.getSimpleName(), this.hashCode(), WebSocketExtensionFactory.this.containerLifeCycle.getState());
            }
        };
        this.container = container;
        this.containerLifeCycle.addBean(this.inflaterPool);
        this.containerLifeCycle.addBean(this.deflaterPool);
    }

    @Override
    public Extension newInstance(ExtensionConfig config) {
        if (config == null) {
            return null;
        }
        String name = config.getName();
        if (StringUtil.isBlank(name)) {
            return null;
        }
        Class<? extends Extension> extClass = this.getExtension(name);
        if (extClass == null) {
            return null;
        }
        try {
            Extension ext = this.container.getObjectFactory().createInstance(extClass);
            if (ext instanceof AbstractExtension) {
                AbstractExtension aext = (AbstractExtension)ext;
                aext.init(this.container);
                aext.setConfig(config);
            }
            if (ext instanceof CompressExtension) {
                CompressExtension cext = (CompressExtension)ext;
                cext.setInflaterPool(this.inflaterPool);
                cext.setDeflaterPool(this.deflaterPool);
            }
            return ext;
        }
        catch (Exception e) {
            throw new WebSocketException("Cannot instantiate extension: " + extClass, e);
        }
    }

    @Override
    public void start() throws Exception {
        this.containerLifeCycle.start();
    }

    @Override
    public void stop() throws Exception {
        this.containerLifeCycle.stop();
    }

    @Override
    public boolean isRunning() {
        return this.containerLifeCycle.isRunning();
    }

    @Override
    public boolean isStarted() {
        return this.containerLifeCycle.isStarted();
    }

    @Override
    public boolean isStarting() {
        return this.containerLifeCycle.isStarting();
    }

    @Override
    public boolean isStopping() {
        return this.containerLifeCycle.isStopping();
    }

    @Override
    public boolean isStopped() {
        return this.containerLifeCycle.isStopped();
    }

    @Override
    public boolean isFailed() {
        return this.containerLifeCycle.isFailed();
    }

    @Override
    public void addLifeCycleListener(LifeCycle.Listener listener) {
        this.containerLifeCycle.addLifeCycleListener(listener);
    }

    @Override
    public void removeLifeCycleListener(LifeCycle.Listener listener) {
        this.containerLifeCycle.removeLifeCycleListener(listener);
    }

    @Override
    public String dump() {
        return this.containerLifeCycle.dump();
    }

    @Override
    public String dumpSelf() {
        return this.containerLifeCycle.dumpSelf();
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.containerLifeCycle.dump(out, indent);
    }

    public String toString() {
        return this.containerLifeCycle.toString();
    }
}

