/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.jetty.client;

import com.signalfx.shaded.jetty.client.HttpRequest;
import com.signalfx.shaded.jetty.client.api.Request;
import com.signalfx.shaded.jetty.client.api.Response;
import com.signalfx.shaded.jetty.client.api.Result;
import com.signalfx.shaded.jetty.io.CyclicTimeout;
import com.signalfx.shaded.jetty.util.log.Log;
import com.signalfx.shaded.jetty.util.log.Logger;
import com.signalfx.shaded.jetty.util.thread.Scheduler;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class TimeoutCompleteListener
extends CyclicTimeout
implements Response.CompleteListener {
    private static final Logger LOG = Log.getLogger(TimeoutCompleteListener.class);
    private final AtomicReference<Request> request = new AtomicReference();

    public TimeoutCompleteListener(Scheduler scheduler) {
        super(scheduler);
    }

    @Override
    public void onTimeoutExpired() {
        Request request = this.request.getAndSet(null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Total timeout {} ms elapsed for {} on {}", request.getTimeout(), request, this);
        }
        if (request != null) {
            request.abort(new TimeoutException("Total timeout " + request.getTimeout() + " ms elapsed"));
        }
    }

    @Override
    public void onComplete(Result result) {
        Request request = this.request.getAndSet(null);
        if (request != null) {
            boolean cancelled = this.cancel();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cancelled ({}) timeout for {} on {}", cancelled, request, this);
            }
        }
    }

    void schedule(HttpRequest request, long timeoutAt) {
        if (this.request.compareAndSet(null, request)) {
            long delay = timeoutAt - System.nanoTime();
            if (delay <= 0L) {
                this.onTimeoutExpired();
            } else {
                this.schedule(delay, TimeUnit.NANOSECONDS);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scheduled timeout in {} ms for {} on {}", TimeUnit.NANOSECONDS.toMillis(delay), request, this);
                }
            }
        }
    }
}

